<?php $__env->startSection('title', 'View Skill'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Skill Details</h1>
    <div class="btn-group" role="group">
        <a href="<?php echo e(route('admin.skills.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Skills
        </a>
        <a href="<?php echo e(route('admin.skills.edit', $skill)); ?>" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <h2><?php echo e($skill->name); ?></h2>
                
                <div class="mb-4">
                    <h5>Proficiency Level</h5>
                    <div class="progress" style="height: 40px;">
                        <div class="progress-bar" role="progressbar" style="width: <?php echo e($skill->percentage); ?>%; background-color: <?php echo e($skill->color); ?>;">
                            <span class="h5 text-white"><?php echo e($skill->percentage); ?>%</span>
                        </div>
                    </div>
                    <p class="mt-2">
                        <?php if($skill->percentage >= 91): ?>
                            <span class="badge bg-success fs-6">Expert Level</span>
                        <?php elseif($skill->percentage >= 76): ?>
                            <span class="badge bg-info fs-6">Advanced Level</span>
                        <?php elseif($skill->percentage >= 51): ?>
                            <span class="badge bg-warning fs-6">Intermediate Level</span>
                        <?php elseif($skill->percentage >= 26): ?>
                            <span class="badge bg-secondary fs-6">Basic Level</span>
                        <?php else: ?>
                            <span class="badge bg-light text-dark fs-6">Beginner Level</span>
                        <?php endif; ?>
                    </p>
                </div>

                <div class="mb-3">
                    <h5>Color</h5>
                    <div class="d-flex align-items-center">
                        <div style="width: 30px; height: 30px; background: <?php echo e($skill->color); ?>; border-radius: 5px; margin-right: 10px;"></div>
                        <code><?php echo e($skill->color); ?></code>
                    </div>
                </div>

                <div class="mb-3">
                    <h5>Status</h5>
                    <?php if($skill->is_active): ?>
                        <span class="badge bg-success fs-6">Active - Visible on website</span>
                    <?php else: ?>
                        <span class="badge bg-danger fs-6">Inactive - Hidden from website</span>
                    <?php endif; ?>
                </div>

                <div class="mb-3">
                    <h5>Display Order</h5>
                    <p class="text-muted">Sort Order: <?php echo e($skill->sort_order ?? 0); ?></p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Skill Information</h5>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->id); ?></dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->created_at->format('M j, Y')); ?><br>
                        <small class="text-muted"><?php echo e($skill->created_at->format('g:i A')); ?></small>
                    </dd>
                    
                    <dt class="col-sm-4">Updated:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->updated_at->format('M j, Y')); ?><br>
                        <small class="text-muted"><?php echo e($skill->updated_at->format('g:i A')); ?></small>
                    </dd>
                    
                    <dt class="col-sm-4">Percentage:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->percentage); ?>%</dd>
                    
                    <dt class="col-sm-4">Color:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->color); ?></dd>
                    
                    <dt class="col-sm-4">Sort Order:</dt>
                    <dd class="col-sm-8"><?php echo e($skill->sort_order ?? 0); ?></dd>
                </dl>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('admin.skills.edit', $skill)); ?>" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Skill
                    </a>
                    
                    <a href="<?php echo e(route('home')); ?>#about" target="_blank" class="btn btn-success">
                        <i class="fas fa-eye"></i> View on Website
                    </a>
                    
                    <hr>
                    
                    <form action="<?php echo e(route('admin.skills.destroy', $skill)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this skill? This action cannot be undone.')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Skill
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Website Preview</h5>
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">How this appears on your website:</p>
                <div class="border rounded p-2">
                    <p class="mb-1"><strong><?php echo e($skill->name); ?></strong></p>
                    <div style="background: #f0f0f0; height: 20px; border-radius: 10px; overflow: hidden;">
                        <div style="width: <?php echo e($skill->percentage); ?>%; height: 100%; background: <?php echo e($skill->color); ?>; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                            <small class="text-white" style="font-size: 10px;"><strong><?php echo e($skill->percentage); ?>%</strong></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/skills/show.blade.php ENDPATH**/ ?>