<?php $__env->startSection('title', 'Banners'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Banners</h1>
    <a href="<?php echo e(route('admin.banners.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Banner
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($banners->count() > 0): ?>
            <div class="row">
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card h-100">
                            <div class="position-relative">
                                <?php if(filter_var($banner->background_image, FILTER_VALIDATE_URL)): ?>
                                    <img src="<?php echo e($banner->background_image); ?>" class="card-img-top" alt="<?php echo e($banner->title); ?>" style="height: 200px; object-fit: cover;">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('storage/' . $banner->background_image)); ?>" class="card-img-top" alt="<?php echo e($banner->title); ?>" style="height: 200px; object-fit: cover;">
                                <?php endif; ?>
                                
                                <!-- Banner overlay preview -->
                                <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" style="background: rgba(0,0,0,0.4);">
                                    <?php if($banner->overlay_text): ?>
                                        <div class="text-center" style="color: <?php echo e($banner->text_color); ?>;">
                                            <h5 class="mb-0"><?php echo e($banner->overlay_text); ?></h5>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Position badge -->
                                <span class="position-absolute top-0 end-0 m-2 badge bg-<?php echo e($banner->position === 'hero' ? 'primary' : ($banner->position === 'portfolio' ? 'info' : ($banner->position === 'contact' ? 'success' : 'secondary'))); ?>">
                                    <?php echo e(ucfirst($banner->position)); ?>

                                </span>
                                
                                <!-- Status badge -->
                                <span class="position-absolute top-0 start-0 m-2 badge bg-<?php echo e($banner->is_active ? 'success' : 'danger'); ?>">
                                    <?php echo e($banner->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </div>
                            
                            <div class="card-body">
                                <h5 class="card-title"><?php echo e($banner->title); ?></h5>
                                <?php if($banner->subtitle): ?>
                                    <p class="card-text text-muted small"><?php echo e($banner->subtitle); ?></p>
                                <?php endif; ?>
                                
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <small class="text-muted">Order: <?php echo e($banner->sort_order); ?></small>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.banners.show', $banner)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.banners.edit', $banner)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.banners.destroy', $banner)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this banner?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-image fa-3x mb-3"></i>
                <p class="h5">No banners found</p>
                <p>Create your first banner to customize the parallax sections of your website.</p>
                <a href="<?php echo e(route('admin.banners.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First Banner
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($banners->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Banner Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo e($banners->count()); ?></h4>
                            <small class="text-muted">Total Banners</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo e($banners->where('is_active', true)->count()); ?></h4>
                            <small class="text-muted">Active Banners</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo e($banners->whereNotNull('button_text')->count()); ?></h4>
                            <small class="text-muted">With Buttons</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo e($banners->groupBy('position')->count()); ?></h4>
                            <small class="text-muted">Positions Used</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/banners/index.blade.php ENDPATH**/ ?>