<?php $__env->startSection('title', 'Contact Messages'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">
        Contact Messages 
        <?php if($unreadCount > 0): ?>
            <span class="badge bg-danger"><?php echo e($unreadCount); ?> unread</span>
        <?php endif; ?>
    </h1>
    <div class="btn-group" role="group">
        <a href="<?php echo e(route('admin.contact-messages.index')); ?>" class="btn btn-outline-primary <?php echo e(!request('status') ? 'active' : ''); ?>">
            All Messages
        </a>
        <a href="<?php echo e(route('admin.contact-messages.index', ['status' => 'unread'])); ?>" class="btn btn-outline-warning <?php echo e(request('status') === 'unread' ? 'active' : ''); ?>">
            Unread (<?php echo e($unreadCount); ?>)
        </a>
        <a href="<?php echo e(route('admin.contact-messages.index', ['status' => 'read'])); ?>" class="btn btn-outline-success <?php echo e(request('status') === 'read' ? 'active' : ''); ?>">
            Read
        </a>
    </div>
</div>

<?php if($unreadCount > 0): ?>
    <div class="mb-3">
        <form action="<?php echo e(route('admin.contact-messages.mark-all-read')); ?>" method="POST" class="d-inline">
            <?php echo csrf_field(); ?>
            <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Mark all messages as read?')">
                <i class="fas fa-check-double"></i> Mark All as Read
            </button>
        </form>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <?php if($messages->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Message Preview</th>
                            <th>Received</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e(!$message->is_read ? 'table-warning' : ''); ?>">
                                <td>
                                    <?php if($message->is_read): ?>
                                        <span class="badge bg-success">Read</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning">Unread</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?php echo e($message->name); ?></strong>
                                    <?php if(!$message->is_read): ?>
                                        <i class="fas fa-circle text-primary" style="font-size: 8px;"></i>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="mailto:<?php echo e($message->email); ?>"><?php echo e($message->email); ?></a>
                                </td>
                                <td>
                                    <div class="text-truncate" style="max-width: 300px;">
                                        <?php echo e(Str::limit($message->message, 100)); ?>

                                    </div>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        <?php echo e($message->created_at->format('M j, Y')); ?><br>
                                        <?php echo e($message->created_at->format('g:i A')); ?>

                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.contact-messages.show', $message)); ?>" 
                                           class="btn btn-outline-info" title="View Message">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.contact-messages.toggle-read', $message)); ?>" 
                                              method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="btn btn-outline-<?php echo e($message->is_read ? 'warning' : 'success'); ?>" 
                                                    title="<?php echo e($message->is_read ? 'Mark as Unread' : 'Mark as Read'); ?>">
                                                <i class="fas fa-<?php echo e($message->is_read ? 'envelope' : 'envelope-open'); ?>"></i>
                                            </button>
                                        </form>
                                        <form action="<?php echo e(route('admin.contact-messages.destroy', $message)); ?>" 
                                              method="POST" class="d-inline" 
                                              onsubmit="return confirm('Are you sure you want to delete this message?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                <?php echo e($messages->withQueryString()->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p class="h5">No contact messages found</p>
                <p>Messages sent through the contact form will appear here.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/contact-messages/index.blade.php ENDPATH**/ ?>