<?php $__env->startSection('title', $siteSettings['site_title'] ?? 'My Portfolio'); ?>

<?php $__env->startSection('content'); ?>
<!-- Modern Hero Banner -->
<div class="bgimg-1 w3-display-container modern-banner" id="home">
    <div class="banner-floating-elements">
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
    </div>
    <div class="w3-display-middle banner-content">
        <?php if(isset($banners['hero']) && $banners['hero']): ?>
            <h1 class="banner-title">
                <?php echo e($banners['hero']->overlay_text ?? $banners['hero']->title); ?>

            </h1>
            <?php if($banners['hero']->subtitle): ?>
                <p class="banner-subtitle"><?php echo e($banners['hero']->subtitle); ?></p>
            <?php endif; ?>
            <?php if($siteSettings['hero_description']): ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description']); ?></p>
            <?php else: ?>
                <p class="banner-description">Creating exceptional digital experiences through innovative design and cutting-edge technology</p>
            <?php endif; ?>
            <div class="banner-buttons">
                <?php if($banners['hero']->button_text && $banners['hero']->button_url): ?>
                    <a href="<?php echo e($banners['hero']->button_url); ?>" class="banner-btn primary">
                        <i class="fa fa-rocket"></i>
                        <?php echo e($banners['hero']->button_text); ?>

                    </a>
                <?php else: ?>
                    <a href="#portfolio" class="banner-btn primary">
                        <i class="fa fa-eye"></i>
                        View My Work
                    </a>
                <?php endif; ?>
                <a href="#contact" class="banner-btn secondary">
                    <i class="fa fa-envelope"></i>
                    Get In Touch
                </a>
            </div>
        <?php else: ?>
            <h1 class="banner-title">
                <?php echo e($siteSettings['site_title'] ?? $siteSettings['site_logo'] ?? 'MY PORTFOLIO'); ?>

            </h1>
            <p class="banner-subtitle">Creative Professional & Digital Innovator</p>
            <p class="banner-description">Creating exceptional digital experiences through innovative design and cutting-edge technology</p>
            <div class="banner-buttons">
                <a href="#portfolio" class="banner-btn primary">
                    <i class="fa fa-eye"></i>
                    View My Work
                </a>
                <a href="#contact" class="banner-btn secondary">
                    <i class="fa fa-envelope"></i>
                    Get In Touch
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modern About Section -->
<section class="modern-about-section" id="about">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="about-header w3-center w3-margin-bottom">
                <h2 class="about-section-title"><?php echo e($siteSettings['about_title'] ?? 'About Me'); ?></h2>
                <p class="about-section-subtitle"><?php echo e($siteSettings['about_subtitle'] ?? 'Passionate about creating exceptional digital experiences'); ?></p>
                <div class="about-title-divider"></div>
            </div>

            <?php if($aboutSections->count() > 0): ?>
                <!-- About Content Grid -->
                <div class="modern-about-content">
                    <?php $__currentLoopData = $aboutSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-about-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 200); ?>">
                            <?php if($section->image): ?>
                                <div class="about-card-layout <?php echo e($index % 2 == 0 ? 'image-left' : 'image-right'); ?>">
                                    <!-- Image Section -->
                                    <div class="about-image-wrapper">
                                        <div class="about-image-container">
                                            <?php if(filter_var($section->image, FILTER_VALIDATE_URL)): ?>
                                                <img src="<?php echo e($section->image); ?>" alt="<?php echo e($section->title); ?>" class="about-image">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/' . $section->image)); ?>" alt="<?php echo e($section->title); ?>" class="about-image">
                                            <?php endif; ?>
                                            <div class="about-image-overlay">
                                                <div class="about-image-decoration"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Content Section -->
                                    <div class="about-content-wrapper">
                                        <div class="about-content-inner">
                                            <div class="about-content-badge"><?php echo e(sprintf('%02d', $index + 1)); ?></div>
                                            <h3 class="about-content-title"><?php echo e($section->title); ?></h3>
                                            <?php if($section->subtitle): ?>
                                                <p class="about-content-subtitle"><?php echo e($section->subtitle); ?></p>
                                            <?php endif; ?>
                                            <div class="about-content-text">
                                                <p><?php echo nl2br(e($section->content)); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <!-- Full Width Content Card -->
                                <div class="about-full-width-card">
                                    <div class="about-content-badge"><?php echo e(sprintf('%02d', $index + 1)); ?></div>
                                    <h3 class="about-content-title"><?php echo e($section->title); ?></h3>
                                    <?php if($section->subtitle): ?>
                                        <p class="about-content-subtitle"><?php echo e($section->subtitle); ?></p>
                                    <?php endif; ?>
                                    <div class="about-content-text">
                                        <p><?php echo nl2br(e($section->content)); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <!-- Default About Content -->
                <div class="modern-about-content">
                    <div class="modern-about-card" data-aos="fade-up">
                        <div class="about-full-width-card">
                            <div class="about-content-badge">01</div>
                            <h3 class="about-content-title">Welcome to My Portfolio</h3>
                            <p class="about-content-subtitle">Creative Professional & Digital Innovator</p>
                            <div class="about-content-text">
                                <p>I am a passionate creative professional dedicated to delivering exceptional work and meaningful digital experiences. With years of experience in the industry, I specialize in creating innovative solutions that combine aesthetic appeal with functional excellence.</p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Skills & Profile Section -->
            <?php if($skills->count() > 0): ?>
                <div class="modern-skills-section">
                    <div class="skills-layout">
                        <!-- Profile Card -->
                        <div class="modern-profile-card" data-aos="fade-right">
                            <div class="profile-image-wrapper">
                                <?php if(filter_var($siteSettings['profile_image'] ?? '', FILTER_VALIDATE_URL)): ?>
                                    <img src="<?php echo e($siteSettings['profile_image']); ?>" alt="Profile Photo" class="profile-image">
                                <?php else: ?>
                                    <img src="https://www.w3schools.com/w3images/avatar_hat.jpg" alt="Profile Photo" class="profile-image">
                                <?php endif; ?>
                                <div class="profile-image-border"></div>
                            </div>
                            <div class="profile-info">
                                <h3 class="profile-name"><?php echo e($siteSettings['profile_name'] ?? 'Professional Name'); ?></h3>
                                <p class="profile-title"><?php echo e($siteSettings['profile_job_title'] ?? 'Creative Professional'); ?></p>
                                <p class="profile-description"><?php echo e($siteSettings['welcome_text'] ?? 'Passionate about creating exceptional digital experiences and innovative solutions.'); ?></p>
                            </div>
                        </div>
                        
                        <!-- Skills Card -->
                        <div class="modern-skills-card" data-aos="fade-left">
                            <h3 class="skills-title"><?php echo e($siteSettings['skills_title'] ?? 'Core Expertise'); ?></h3>
                            <p class="skills-subtitle"><?php echo e($siteSettings['skills_description'] ?? 'My key areas of specialization'); ?></p>
                            
                            <div class="skills-grid">
                                <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="modern-skill-item">
                                        <div class="skill-header">
                                            <span class="skill-name"><?php echo e($skill->name); ?></span>
                                            <span class="skill-percentage"><?php echo e($skill->percentage); ?>%</span>
                                        </div>
                                        <div class="skill-progress-wrapper">
                                            <div class="skill-progress-track"></div>
                                            <div class="skill-progress-bar" 
                                                 data-percentage="<?php echo e($skill->percentage); ?>" 
                                                 style="background: linear-gradient(90deg, <?php echo e($skill->color); ?>, <?php echo e($skill->color); ?>80);">
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="about-bg-elements">
        <div class="about-bg-shape about-bg-shape-1"></div>
        <div class="about-bg-shape about-bg-shape-2"></div>
        <div class="about-bg-pattern"></div>
    </div>
</section>

<!-- Modern Statistics Section -->
<?php if($statistics->count() > 0): ?>
    <section class="modern-stats-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="stats-header w3-center w3-margin-bottom">
                    <h2 class="stats-section-title"><?php echo e($siteSettings['stats_title'] ?? 'Achievements & Milestones'); ?></h2>
                    <p class="stats-section-subtitle"><?php echo e($siteSettings['stats_subtitle'] ?? 'Numbers that showcase our journey and success story'); ?></p>
                    <div class="stats-title-divider"></div>
                </div>

                <!-- Statistics Grid -->
                <div class="modern-stats-grid">
                    <!-- FontAwesome Test (remove this after testing) -->
                    <div style="display: none;">
                        <i class="fa fa-heart"></i>
                        <i class="fa fa-users"></i>
                        <i class="fa fa-bar-chart"></i>
                        <i class="fa fa-trophy"></i>
                        <i class="fa fa-calendar"></i>
                        <i class="fa fa-handshake-o"></i>
                    </div>
                    <?php $__currentLoopData = $statistics->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-stat-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                            <div class="stat-card-inner">
                                <!-- Icon -->
                                <?php if($stat->icon): ?>
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="<?php echo e($stat->icon); ?> stat-icon" title="Icon: <?php echo e($stat->icon); ?>"></i>
                                    </div>
                                <?php else: ?>
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="fa fa-bar-chart stat-icon" title="Default Icon"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <!-- Counter -->
                                <div class="stat-counter-wrapper">
                                    <span class="stat-counter" data-count="<?php echo e($stat->value); ?>">0</span>
                                    <span class="stat-suffix"><?php echo e($stat->suffix); ?></span>
                                </div>
                                
                                <!-- Label -->
                                <h4 class="stat-label"><?php echo e($stat->label); ?></h4>
                                
                                <!-- Progress Bar -->
                                <div class="stat-progress-bar">
                                    <div class="stat-progress-fill" data-percentage="<?php echo e(min(100, ($stat->value / max($statistics->max('value'), 1)) * 100)); ?>"></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Additional Stats Indicator -->
                <?php if($statistics->count() > 4): ?>
                    <div class="additional-stats-info w3-center w3-margin-top">
                        <div class="additional-stats-badge">
                            <i class="fa fa-plus-circle"></i>
                            <span><?php echo e($statistics->count() - 4); ?> More Achievements</span>
                        </div>
                        <p class="additional-stats-text">Discover more milestones in our complete portfolio</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="stats-bg-elements">
            <div class="stats-bg-circle stats-bg-circle-1"></div>
            <div class="stats-bg-circle stats-bg-circle-2"></div>
            <div class="stats-bg-circle stats-bg-circle-3"></div>
        </div>
    </section>
<?php endif; ?>

<!-- Second Parallax Image with Portfolio Text -->
<div class="bgimg-2 w3-display-container w3-opacity-min">
    <div class="w3-display-middle">
        <?php if(isset($banners['portfolio']) && $banners['portfolio']): ?>
            <div class="w3-center" style="color: <?php echo e($banners['portfolio']->text_color); ?>;">
                <span class="w3-xxlarge"><?php echo e($banners['portfolio']->overlay_text ?? $banners['portfolio']->title); ?></span>
                <?php if($banners['portfolio']->subtitle): ?>
                    <p class="w3-large w3-margin-top"><?php echo e($banners['portfolio']->subtitle); ?></p>
                <?php endif; ?>
                <?php if($banners['portfolio']->button_text && $banners['portfolio']->button_url): ?>
                    <div class="w3-margin-top">
                        <a href="<?php echo e($banners['portfolio']->button_url); ?>" class="w3-button w3-white w3-large w3-hover-black">
                            <?php echo e($banners['portfolio']->button_text); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <span class="w3-xxlarge w3-text-white">PORTFOLIO</span>
        <?php endif; ?>
    </div>
</div>

<!-- Modern Portfolio Section -->
<section class="modern-portfolio-section" id="portfolio">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="portfolio-header w3-center w3-margin-bottom">
                <h2 class="portfolio-section-title"><?php echo e($siteSettings['portfolio_title'] ?? 'Latest Projects'); ?></h2>
                <p class="portfolio-section-subtitle"><?php echo e($siteSettings['portfolio_subtitle'] ?? 'Discover our most recent creative work and innovative solutions'); ?></p>
                <div class="portfolio-title-divider"></div>
            </div>

            <?php if($portfolioItems->count() > 0): ?>
                <!-- Portfolio Grid -->
                <div class="modern-portfolio-grid">
                    <?php $__currentLoopData = $portfolioItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 150); ?>">
                            <div class="portfolio-card-inner">
                                <!-- Image Container -->
                                <div class="portfolio-image-wrapper">
                                    <?php if(filter_var($item->image, FILTER_VALIDATE_URL)): ?>
                                        <img src="<?php echo e($item->image); ?>" alt="<?php echo e($item->title); ?>" class="portfolio-image" onclick="onClick(this)" data-title="<?php echo e($item->title); ?>" data-description="<?php echo e($item->description); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('storage/' . $item->image)); ?>" alt="<?php echo e($item->title); ?>" class="portfolio-image" onclick="onClick(this)" data-title="<?php echo e($item->title); ?>" data-description="<?php echo e($item->description); ?>">
                                    <?php endif; ?>
                                    
                                    <!-- Overlay -->
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title"><?php echo e($item->title); ?></h4>
                                            <?php if($item->category): ?>
                                                <p class="portfolio-overlay-category"><?php echo e($item->category); ?></p>
                                            <?php endif; ?>
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.previousElementSibling.previousElementSibling)" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                                <?php if($item->url): ?>
                                                    <a href="<?php echo e($item->url); ?>" target="_blank" class="portfolio-btn portfolio-btn-link">
                                                        <i class="fa fa-external-link"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Content -->
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        <?php if($item->category): ?>
                                            <span class="portfolio-category-tag"><?php echo e($item->category); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <h4 class="portfolio-title"><?php echo e($item->title); ?></h4>
                                    <?php if($item->description): ?>
                                        <p class="portfolio-description"><?php echo e(Str::limit($item->description, 80)); ?></p>
                                    <?php endif; ?>
                                    
                                    <!-- Action Buttons -->
                                    <div class="portfolio-actions">
                                        <button onclick="onClick(this)" class="portfolio-action-btn primary" data-image="<?php echo e(filter_var($item->image, FILTER_VALIDATE_URL) ? $item->image : asset('storage/' . $item->image)); ?>" data-title="<?php echo e($item->title); ?>" data-description="<?php echo e($item->description); ?>">
                                            <i class="fa fa-eye"></i>
                                            <span>Quick View</span>
                                        </button>
                                        <?php if($item->url): ?>
                                            <a href="<?php echo e($item->url); ?>" target="_blank" class="portfolio-action-btn secondary">
                                                <i class="fa fa-external-link"></i>
                                                <span>Visit</span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- View All Button -->
                <?php if($allPortfolioCount > 3): ?>
                    <div class="portfolio-view-all w3-center">
                        <a href="<?php echo e(route('portfolio.index')); ?>" class="modern-view-all-btn">
                            <span class="btn-text">View All Portfolio</span>
                            <span class="btn-count">(<?php echo e($allPortfolioCount); ?> Projects)</span>
                            <i class="fa fa-arrow-right btn-arrow"></i>
                            <div class="btn-ripple"></div>
                        </a>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <!-- Default Portfolio Items -->
                <div class="modern-portfolio-grid">
                    <?php
                        $defaultItems = [
                            ['image' => 'https://www.w3schools.com/w3images/p1.jpg', 'title' => 'Mountain Mist', 'category' => 'Photography'],
                            ['image' => 'https://www.w3schools.com/w3images/p2.jpg', 'title' => 'Coffee Beans', 'category' => 'Product'],
                            ['image' => 'https://www.w3schools.com/w3images/p3.jpg', 'title' => 'Bear Closeup', 'category' => 'Wildlife']
                        ];
                    ?>
                    <?php $__currentLoopData = $defaultItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 150); ?>">
                            <div class="portfolio-card-inner">
                                <div class="portfolio-image-wrapper">
                                    <img src="<?php echo e($item['image']); ?>" alt="<?php echo e($item['title']); ?>" class="portfolio-image" onclick="onClick(this)">
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title"><?php echo e($item['title']); ?></h4>
                                            <p class="portfolio-overlay-category"><?php echo e($item['category']); ?></p>
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.previousElementSibling.previousElementSibling)" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        <span class="portfolio-category-tag"><?php echo e($item['category']); ?></span>
                                    </div>
                                    <h4 class="portfolio-title"><?php echo e($item['title']); ?></h4>
                                    <p class="portfolio-description">Sample portfolio item showcasing creative work</p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="portfolio-bg-elements">
        <div class="portfolio-bg-shape portfolio-bg-shape-1"></div>
        <div class="portfolio-bg-shape portfolio-bg-shape-2"></div>
    </div>
</section>

<!-- Enhanced Modal for full size images -->
<div id="modal01" class="modern-modal" onclick="this.style.display='none'">
    <div class="modern-modal-backdrop"></div>
    <div class="modern-modal-content">
        <button class="modern-modal-close" title="Close Modal">
            <i class="fa fa-times"></i>
        </button>
        <div class="modern-modal-inner">
            <img id="img01" class="modern-modal-image">
            <div id="caption" class="modern-modal-caption"></div>
        </div>
    </div>
</div>

<!-- Third Parallax Image with Contact Text -->
<div class="bgimg-3 w3-display-container w3-opacity-min">
    <div class="w3-display-middle">
        <?php if(isset($banners['contact']) && $banners['contact']): ?>
            <div class="w3-center" style="color: <?php echo e($banners['contact']->text_color); ?>;">
                <span class="w3-xxlarge"><?php echo e($banners['contact']->overlay_text ?? $banners['contact']->title); ?></span>
                <?php if($banners['contact']->subtitle): ?>
                    <p class="w3-large w3-margin-top"><?php echo e($banners['contact']->subtitle); ?></p>
                <?php endif; ?>
                <?php if($banners['contact']->button_text && $banners['contact']->button_url): ?>
                    <div class="w3-margin-top">
                        <a href="<?php echo e($banners['contact']->button_url); ?>" class="w3-button w3-white w3-large w3-hover-black">
                            <?php echo e($banners['contact']->button_text); ?>

                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <span class="w3-xxlarge w3-text-white">CONTACT</span>
        <?php endif; ?>
    </div>
</div>

<!-- Modern Contact Section -->
<section class="modern-contact-section" id="contact">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="contact-header w3-center w3-margin-bottom">
                <h2 class="section-title"><?php echo e($siteSettings['contact_title'] ?? "Let's Work Together"); ?></h2>
                <p class="section-subtitle"><?php echo e($siteSettings['contact_subtitle'] ?? "Ready to start your next project? Let's create something amazing together."); ?></p>
                <div class="title-divider"></div>
            </div>

            <!-- Contact Cards Row -->
            <div class="contact-cards-row w3-margin-bottom">
                <?php if($contactInfo->count() > 0): ?>
                    <?php
                        $contactTypes = $contactInfo->whereIn('type', ['address', 'phone', 'email'])->sortBy('sort_order');
                    ?>
                    <?php $__currentLoopData = $contactTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa <?php echo e($contact->icon ?? 'fa-info'); ?>"></i>
                            </div>
                            <h4 class="contact-card-title"><?php echo e($contact->label); ?></h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <?php if($contact->type === 'email'): ?>
                                        <a href="mailto:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                    <?php elseif($contact->type === 'phone'): ?>
                                        <a href="tel:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                    <?php else: ?>
                                        <p><?php echo nl2br(e($contact->value)); ?></p>
                                    <?php endif; ?>
                                </div>
                                <?php if(in_array($contact->type, ['email', 'phone'])): ?>
                                    <div class="contact-card-action">
                                        <?php if($contact->type === 'email'): ?>
                                            <a href="mailto:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                <i class="fa fa-envelope"></i> Send Email
                                            </a>
                                        <?php elseif($contact->type === 'phone'): ?>
                                            <a href="tel:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                <i class="fa fa-phone"></i> Call Now
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <!-- Default Contact Cards -->
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <h4 class="contact-card-title">Visit Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <p>123 Business Street<br>Suite 100<br>City, State 12345</p>
                            </div>
                        </div>
                    </div>
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-phone"></i>
                        </div>
                        <h4 class="contact-card-title">Call Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <a href="tel:+1234567890" class="contact-link">+1 (234) 567-890</a>
                            </div>
                            <div class="contact-card-action">
                                <a href="tel:+1234567890" class="contact-action-btn">
                                    <i class="fa fa-phone"></i> Call Now
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-envelope"></i>
                        </div>
                        <h4 class="contact-card-title">Email Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <a href="mailto:hello@example.com" class="contact-link">hello@example.com</a>
                            </div>
                            <div class="contact-card-action">
                                <a href="mailto:hello@example.com" class="contact-action-btn">
                                    <i class="fa fa-envelope"></i> Send Email
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Contact Form Section -->
            <div class="modern-contact-form-section w3-row">
                <div class="w3-col l6 m12 s12 w3-padding-large">
                    <div class="contact-form-intro">
                        <h3 class="form-title"><?php echo e($siteSettings['contact_form_title'] ?? 'Send Message'); ?></h3>
                        <p class="form-description"><?php echo e($siteSettings['contact_form_message'] ?? "Have a project in mind? Let's discuss how we can work together to bring your ideas to life."); ?></p>
                        
                        <!-- Business Hours -->
                        <?php $__currentLoopData = $contactInfo->where('type', 'other'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="business-info">
                                <?php if($contact->icon): ?>
                                    <i class="fa <?php echo e($contact->icon); ?> info-icon"></i>
                                <?php endif; ?>
                                <div class="info-content">
                                    <strong><?php echo e($contact->label); ?></strong>
                                    <p><?php echo nl2br(e($contact->value)); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <!-- Response Time -->
                        <div class="response-time">
                            <i class="fa fa-clock-o info-icon"></i>
                            <div class="info-content">
                                <strong>Response Time</strong>
                                <p><?php echo e($siteSettings['response_time'] ?? 'I typically respond within 24 hours during business days.'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="w3-col l6 m12 s12 w3-padding-large">
                    <div class="modern-contact-form">
                        <!-- Success/Error Messages -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <i class="fa fa-check-circle"></i>
                                <span><?php echo e(session('success')); ?></span>
                            </div>
                        <?php endif; ?>

                        <?php if($errors->any()): ?>
                            <div class="alert alert-error">
                                <i class="fa fa-exclamation-triangle"></i>
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <form action="<?php echo e(route('contact.store')); ?>" method="POST" class="contact-form">
                            <?php echo csrf_field(); ?>
                            <div class="form-group-row">
                                <div class="form-group">
                                    <input type="text" name="name" value="<?php echo e(old('name')); ?>" required 
                                           class="modern-input <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           placeholder=" ">
                                    <label class="modern-label">Full Name *</label>
                                    <div class="input-border"></div>
                                </div>
                                <div class="form-group">
                                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" required 
                                           class="modern-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           placeholder=" ">
                                    <label class="modern-label">Email Address *</label>
                                    <div class="input-border"></div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" 
                                       class="modern-input" placeholder=" ">
                                <label class="modern-label">Subject</label>
                                <div class="input-border"></div>
                            </div>
                            
                            <div class="form-group">
                                <textarea name="message" rows="5" required 
                                          class="modern-input modern-textarea <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                          placeholder=" "><?php echo e(old('message')); ?></textarea>
                                <label class="modern-label">Your Message *</label>
                                <div class="input-border"></div>
                            </div>
                            
                            <button type="submit" class="modern-submit-btn">
                                <span class="btn-text">Send Message</span>
                                <i class="fa fa-paper-plane btn-icon"></i>
                                <div class="btn-ripple"></div>
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Social Media Section -->
            <?php if($contactInfo->whereIn('type', ['social', 'website'])->count() > 0): ?>
                <div class="social-connect-section w3-center w3-margin-top">
                    <h4 class="social-title">Let's Connect</h4>
                    <p class="social-subtitle">Follow me on social media for updates and behind-the-scenes content</p>
                    <div class="modern-social-links">
                        <?php $__currentLoopData = $contactInfo->where('type', 'social'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL)): ?>
                                <a href="<?php echo e($social->value); ?>" target="_blank" class="modern-social-btn" title="<?php echo e($social->label); ?>">
                                    <i class="fa <?php echo e($social->icon ?? 'fa-share-alt'); ?>"></i>
                                    <span class="social-label"><?php echo e($social->label); ?></span>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <?php $__currentLoopData = $contactInfo->where('type', 'website'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $website): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($website->is_active && filter_var($website->value, FILTER_VALIDATE_URL)): ?>
                                <a href="<?php echo e($website->value); ?>" target="_blank" class="modern-social-btn website-btn" title="<?php echo e($website->label); ?>">
                                    <i class="fa <?php echo e($website->icon ?? 'fa-globe'); ?>"></i>
                                    <span class="social-label"><?php echo e($website->label); ?></span>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<script>
// Enhanced Modal Image Gallery
function onClick(element) {
    var modal = document.getElementById("modal01");
    var modalImg = document.getElementById("img01");
    var captionText = document.getElementById("caption");
    
    // Handle different element types
    if (element.tagName === 'IMG') {
        modalImg.src = element.src;
        captionText.innerHTML = element.alt || element.getAttribute('data-title') || '';
    } else if (element.tagName === 'BUTTON') {
        // Handle portfolio action button clicks
        var imageSrc = element.getAttribute('data-image');
        var title = element.getAttribute('data-title');
        var description = element.getAttribute('data-description');
        
        if (imageSrc) {
            modalImg.src = imageSrc;
            captionText.innerHTML = title + (description ? '<br><em>' + description + '</em>' : '');
        }
    }
    
    modal.style.display = "block";
    
    // Add smooth fade-in animation
    modal.style.opacity = "0";
    setTimeout(function() {
        modal.style.opacity = "1";
    }, 10);
}

// Enhanced modal close
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById("modal01");
    if (modal) {
        modal.addEventListener('click', function() {
            this.style.opacity = "0";
            setTimeout(function() {
                modal.style.display = "none";
            }, 300);
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/frontend/home.blade.php ENDPATH**/ ?>