<?php $__env->startSection('title', ($siteSettings['contact_title'] ?? 'Contact Me') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio')); ?>

<?php $__env->startSection('content'); ?>
<!-- Modern Contact Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    <?php if(isset($banners['contact']) && $banners['contact']): ?>
        <div class="w3-display-container" style="background-image: url('<?php echo e($banners['contact']->background_image); ?>'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($banners['contact']->overlay_text ?? $banners['contact']->title); ?></h1>
                <?php if($banners['contact']->subtitle): ?>
                    <p class="banner-subtitle"><?php echo e($banners['contact']->subtitle); ?></p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <?php if($banners['contact']->button_text && $banners['contact']->button_url): ?>
                        <a href="<?php echo e($banners['contact']->button_url); ?>" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            <?php echo e($banners['contact']->button_text); ?>

                        </a>
                    <?php else: ?>
                        <a href="#contact-form" class="banner-btn primary">
                            <i class="fa fa-envelope"></i>
                            Send Message
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('portfolio.index')); ?>" class="banner-btn secondary">
                        <i class="fa fa-th"></i>
                        View Portfolio
                    </a>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bgimg-3 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($siteSettings['contact_title'] ?? 'CONTACT ME'); ?></h1>
                <?php if($siteSettings['contact_subtitle']): ?>
                    <p class="banner-subtitle"><?php echo e($siteSettings['contact_subtitle']); ?></p>
                <?php else: ?>
                    <p class="banner-subtitle">Let's Connect & Create</p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <a href="#contact-form" class="banner-btn primary">
                        <i class="fa fa-envelope"></i>
                        Send Message
                    </a>
                    <a href="<?php echo e(route('portfolio.index')); ?>" class="banner-btn secondary">
                        <i class="fa fa-th"></i>
                        View Portfolio
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Modern Contact Information Cards -->
<?php if($contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->count() > 0): ?>
    <section class="modern-contact-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title"><?php echo e($siteSettings['contact_info_title'] ?? 'Get In Touch'); ?></h2>
                    <p class="section-subtitle"><?php echo e($siteSettings['contact_info_subtitle'] ?? 'Feel free to reach out through any of these channels'); ?></p>
                    <div class="title-divider"></div>
                </div>

                <!-- Contact Cards Row -->
                <div class="contact-cards-row w3-margin-bottom">
                    <?php $__currentLoopData = $contactInfo->whereIn('type', ['address', 'phone', 'email', 'website']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa <?php echo e($contact->icon ?? 'fa-info'); ?>"></i>
                            </div>
                            <h4 class="contact-card-title"><?php echo e($contact->label); ?></h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <?php if($contact->type === 'email'): ?>
                                        <a href="mailto:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                    <?php elseif($contact->type === 'phone'): ?>
                                        <a href="tel:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                    <?php elseif($contact->type === 'website'): ?>
                                        <p><?php echo e($contact->value); ?></p>
                                    <?php else: ?>
                                        <p><?php echo nl2br(e($contact->value)); ?></p>
                                    <?php endif; ?>
                                </div>
                                <?php if(in_array($contact->type, ['email', 'phone', 'website'])): ?>
                                    <div class="contact-card-action">
                                        <?php if($contact->type === 'email'): ?>
                                            <a href="mailto:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                <i class="fa fa-envelope"></i> Send Email
                                            </a>
                                        <?php elseif($contact->type === 'phone'): ?>
                                            <a href="tel:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                <i class="fa fa-phone"></i> Call Now
                                            </a>
                                        <?php elseif($contact->type === 'website'): ?>
                                            <a href="<?php echo e($contact->value); ?>" target="_blank" class="contact-action-btn">
                                                <i class="fa fa-globe"></i> Visit Website
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Contact Form Section -->
<section class="modern-contact-section" id="contact-form">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="contact-header w3-center w3-margin-bottom">
                <h2 class="section-title"><?php echo e($siteSettings['contact_form_title'] ?? 'Send Message'); ?></h2>
                <p class="section-subtitle"><?php echo e($siteSettings['contact_form_description'] ?? 'Ready to start your next project? Let\'s create something amazing together.'); ?></p>
                <div class="title-divider"></div>
            </div>

            <!-- Contact Form -->
            <div class="modern-contact-form-section">
                <div class="modern-contact-form">
                    <!-- Success/Error Messages -->
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <i class="fa fa-check-circle"></i>
                            <span><?php echo e(session('success')); ?></span>
                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-error">
                            <i class="fa fa-exclamation-triangle"></i>
                            <ul>
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('contact.store')); ?>" method="POST" class="contact-form">
                        <?php echo csrf_field(); ?>
                        <div class="form-group-row">
                            <div class="form-group">
                                <input type="text" name="name" value="<?php echo e(old('name')); ?>" required 
                                       class="modern-input <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder=" ">
                                <label class="modern-label">Full Name *</label>
                                <div class="input-border"></div>
                            </div>
                            <div class="form-group">
                                <input type="email" name="email" value="<?php echo e(old('email')); ?>" required 
                                       class="modern-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       placeholder=" ">
                                <label class="modern-label">Email Address *</label>
                                <div class="input-border"></div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" 
                                   class="modern-input" placeholder=" ">
                            <label class="modern-label">Subject</label>
                            <div class="input-border"></div>
                        </div>
                        
                        <div class="form-group">
                            <textarea name="message" rows="6" required 
                                      class="modern-input modern-textarea <?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> error <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      placeholder=" "><?php echo e(old('message')); ?></textarea>
                            <label class="modern-label">Your Message *</label>
                            <div class="input-border"></div>
                        </div>
                        
                        <button type="submit" class="modern-submit-btn">
                            <span class="btn-text">Send Message</span>
                            <i class="fa fa-paper-plane btn-icon"></i>
                            <div class="btn-ripple"></div>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modern Business Hours & Additional Info -->
<?php if($contactInfo->where('type', 'other')->count() > 0): ?>
    <section class="modern-info-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title"><?php echo e($siteSettings['business_info_title'] ?? 'Business Information'); ?></h2>
                    <div class="title-divider"></div>
                </div>
                
                <div class="info-cards-grid">
                    <?php $__currentLoopData = $contactInfo->where('type', 'other'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $info): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-info-card">
                            <div class="info-card-icon">
                                <i class="fa <?php echo e($info->icon ?? 'fa-info-circle'); ?>"></i>
                            </div>
                            <h4 class="info-card-title"><?php echo e($info->label); ?></h4>
                            <div class="info-card-content">
                                <p><?php echo nl2br(e($info->value)); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Social Media Section -->
<?php if($contactInfo->where('type', 'social')->count() > 0): ?>
    <section class="modern-social-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="social-header w3-center w3-margin-bottom">
                    <h2 class="social-section-title"><?php echo e($siteSettings['social_title'] ?? 'Let\'s Connect'); ?></h2>
                    <p class="social-section-subtitle"><?php echo e($siteSettings['social_description'] ?? 'Follow me on social media for updates and behind-the-scenes content'); ?></p>
                    <div class="social-title-divider"></div>
                </div>
                
                <div class="social-connect-section w3-center">
                    <div class="modern-social-links">
                        <?php $__currentLoopData = $contactInfo->where('type', 'social'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL)): ?>
                                <a href="<?php echo e($social->value); ?>" target="_blank" class="modern-social-btn" title="<?php echo e($social->label); ?>">
                                    <i class="fa <?php echo e($social->icon ?? 'fa-share-alt'); ?>"></i>
                                    <span class="social-label"><?php echo e($social->label); ?></span>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="social-bg-elements">
            <div class="social-bg-circle social-bg-circle-1"></div>
            <div class="social-bg-circle social-bg-circle-2"></div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Location Section -->
<?php $address = $contactInfo->where('type', 'address')->first(); ?>
<?php if($address): ?>
    <section class="modern-location-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="location-header w3-center w3-margin-bottom">
                    <h2 class="location-section-title"><?php echo e($siteSettings['location_title'] ?? 'Find Me Here'); ?></h2>
                    <p class="location-section-subtitle"><?php echo e($siteSettings['location_description'] ?? 'Visit me at my location or schedule an appointment'); ?></p>
                    <div class="location-title-divider"></div>
                </div>
                
                <div class="location-layout">
                    <!-- Location Info Card -->
                    <div class="modern-location-card" data-aos="fade-right">
                        <div class="location-card-header">
                            <div class="location-icon">
                                <i class="fa <?php echo e($address->icon ?? 'fa-map-marker'); ?>"></i>
                            </div>
                            <h3 class="location-title"><?php echo e($address->label); ?></h3>
                        </div>
                        <div class="location-address">
                            <p><?php echo nl2br(e($address->value)); ?></p>
                        </div>
                        
                        <!-- Quick Contact -->
                        <div class="location-quick-contact">
                            <?php
                                $phone = $contactInfo->where('type', 'phone')->first();
                                $email = $contactInfo->where('type', 'email')->first();
                            ?>
                            
                            <?php if($phone): ?>
                                <div class="quick-contact-item">
                                    <i class="fa <?php echo e($phone->icon ?? 'fa-phone'); ?>"></i>
                                    <a href="tel:<?php echo e($phone->value); ?>"><?php echo e($phone->value); ?></a>
                                </div>
                            <?php endif; ?>
                            
                            <?php if($email): ?>
                                <div class="quick-contact-item">
                                    <i class="fa <?php echo e($email->icon ?? 'fa-envelope'); ?>"></i>
                                    <a href="mailto:<?php echo e($email->value); ?>"><?php echo e($email->value); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Map Card -->
                    <div class="modern-map-card" data-aos="fade-left">
                        <div class="map-placeholder">
                            <div class="map-icon">
                                <i class="fa fa-map"></i>
                            </div>
                            <h4 class="map-title">Interactive Map</h4>
                            <p class="map-description">Click below to view location on Google Maps</p>
                            <a href="https://maps.google.com/?q=<?php echo e(urlencode($address->value)); ?>" target="_blank" class="map-action-btn">
                                <i class="fa fa-map-marker"></i>
                                <span>View on Google Maps</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="location-bg-elements">
            <div class="location-bg-shape location-bg-shape-1"></div>
            <div class="location-bg-shape location-bg-shape-2"></div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Call to Action -->
<section class="modern-cta-section">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <div class="cta-content w3-center">
                <h2 class="cta-title"><?php echo e($siteSettings['contact_cta_title'] ?? 'Let\'s Start a Conversation'); ?></h2>
                <p class="cta-subtitle"><?php echo e($siteSettings['contact_cta_description'] ?? 'Whether you have a project in mind or just want to say hello, I\'d love to hear from you.'); ?></p>
                <div class="cta-actions">
                    <a href="#contact-form" class="cta-btn primary">
                        <i class="fa fa-envelope"></i>
                        <span>Send Message</span>
                    </a>
                    <a href="<?php echo e(route('portfolio.index')); ?>" class="cta-btn secondary">
                        <i class="fa fa-th"></i>
                        <span>View Portfolio</span>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="cta-bg-elements">
            <div class="cta-bg-shape cta-bg-shape-1"></div>
            <div class="cta-bg-shape cta-bg-shape-2"></div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/frontend/contact.blade.php ENDPATH**/ ?>