<?php $__env->startSection('title', 'Site Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Site Settings</h1>
    <a href="<?php echo e(route('admin.site-settings.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Setting
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Group</th>
                        <th>Key</th>
                        <th>Value</th>
                        <th>Type</th>
                        <th>Sort Order</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <span class="badge bg-secondary"><?php echo e($setting->group); ?></span>
                            </td>
                            <td><code><?php echo e($setting->key); ?></code></td>
                            <td>
                                <?php if($setting->type === 'image'): ?>
                                    <?php if(filter_var($setting->value, FILTER_VALIDATE_URL)): ?>
                                        <img src="<?php echo e($setting->value); ?>" alt="Image" class="img-thumbnail" style="max-width: 100px; max-height: 50px;">
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(Str::limit($setting->value, 50)); ?></span>
                                    <?php endif; ?>
                                <?php elseif($setting->type === 'textarea'): ?>
                                    <span class="text-muted"><?php echo e(Str::limit($setting->value, 100)); ?></span>
                                <?php else: ?>
                                    <?php echo e(Str::limit($setting->value, 50)); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-info"><?php echo e($setting->type); ?></span>
                            </td>
                            <td><?php echo e($setting->sort_order); ?></td>
                            <td>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="<?php echo e(route('admin.site-settings.show', $setting)); ?>" class="btn btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.site-settings.edit', $setting)); ?>" class="btn btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.site-settings.destroy', $setting)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this setting?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <p>No site settings found. <a href="<?php echo e(route('admin.site-settings.create')); ?>">Create your first setting</a></p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/site-settings/index.blade.php ENDPATH**/ ?>