<?php $__env->startSection('title', 'Contact Information'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Information</h1>
    <a href="<?php echo e(route('admin.contact-info.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Contact Info
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($contactInfos->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Icon</th>
                            <th>Type</th>
                            <th>Label</th>
                            <th>Value</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $contactInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($contact->icon): ?>
                                        <i class="<?php echo e($contact->icon); ?> fa-lg text-primary"></i>
                                    <?php else: ?>
                                        <i class="fas fa-info-circle fa-lg text-muted"></i>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($contact->type === 'email' ? 'primary' : ($contact->type === 'phone' ? 'success' : ($contact->type === 'address' ? 'info' : 'secondary'))); ?>">
                                        <?php echo e(ucfirst($contact->type)); ?>

                                    </span>
                                </td>
                                <td>
                                    <strong><?php echo e($contact->label); ?></strong>
                                </td>
                                <td>
                                    <?php if($contact->type === 'email'): ?>
                                        <a href="mailto:<?php echo e($contact->value); ?>" class="text-decoration-none"><?php echo e($contact->value); ?></a>
                                    <?php elseif($contact->type === 'phone'): ?>
                                        <a href="tel:<?php echo e($contact->value); ?>" class="text-decoration-none"><?php echo e($contact->value); ?></a>
                                    <?php elseif($contact->type === 'social' && filter_var($contact->value, FILTER_VALIDATE_URL)): ?>
                                        <a href="<?php echo e($contact->value); ?>" target="_blank" class="text-decoration-none"><?php echo e(Str::limit($contact->value, 30)); ?></a>
                                    <?php else: ?>
                                        <?php echo e(Str::limit($contact->value, 50)); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($contact->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($contact->sort_order ?? 0); ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.contact-info.show', $contact)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.contact-info.edit', $contact)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.contact-info.destroy', $contact)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this contact information?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-address-book fa-3x mb-3"></i>
                <p class="h5">No contact information found</p>
                <p>Start by adding your first contact detail to display on your website.</p>
                <a href="<?php echo e(route('admin.contact-info.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Contact Info
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($contactInfos->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Information Preview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php $__currentLoopData = $contactInfos->where('is_active', true)->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 mb-3">
                            <div class="d-flex align-items-center p-3 border rounded">
                                <?php if($contact->icon): ?>
                                    <i class="<?php echo e($contact->icon); ?> fa-lg text-primary me-3"></i>
                                <?php endif; ?>
                                <div>
                                    <strong class="d-block"><?php echo e($contact->label); ?></strong>
                                    <small class="text-muted"><?php echo e(Str::limit($contact->value, 30)); ?></small>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo e($contactInfos->count()); ?></h4>
                            <small class="text-muted">Total Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo e($contactInfos->where('is_active', true)->count()); ?></h4>
                            <small class="text-muted">Active Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo e($contactInfos->whereNotNull('icon')->count()); ?></h4>
                            <small class="text-muted">With Icons</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo e($contactInfos->groupBy('type')->count()); ?></h4>
                            <small class="text-muted">Contact Types</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/contact-info/index.blade.php ENDPATH**/ ?>