<?php $__env->startSection('title', 'Statistics'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Statistics</h1>
    <a href="<?php echo e(route('admin.statistics.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Statistic
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($statistics->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Preview</th>
                            <th>Label</th>
                            <th>Value</th>
                            <th>Suffix</th>
                            <th>Icon</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $statistics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statistic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="text-center p-2 bg-dark text-white rounded" style="min-width: 100px;">
                                        <?php if($statistic->icon): ?>
                                            <i class="<?php echo e($statistic->icon); ?> mb-1"></i><br>
                                        <?php endif; ?>
                                        <span class="h6"><?php echo e($statistic->value); ?><?php echo e($statistic->suffix); ?></span><br>
                                        <small><?php echo e($statistic->label); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <strong><?php echo e($statistic->label); ?></strong>
                                </td>
                                <td>
                                    <span class="badge bg-primary"><?php echo e($statistic->value); ?></span>
                                </td>
                                <td>
                                    <?php if($statistic->suffix): ?>
                                        <code><?php echo e($statistic->suffix); ?></code>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($statistic->icon): ?>
                                        <i class="<?php echo e($statistic->icon); ?>"></i> <code><?php echo e($statistic->icon); ?></code>
                                    <?php else: ?>
                                        <span class="text-muted">No icon</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($statistic->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($statistic->sort_order ?? 0); ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.statistics.show', $statistic)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.statistics.edit', $statistic)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.statistics.destroy', $statistic)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this statistic?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-chart-bar fa-3x mb-3"></i>
                <p class="h5">No statistics found</p>
                <p>Start by adding your first statistic to showcase your achievements.</p>
                <a href="<?php echo e(route('admin.statistics.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Statistic
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($statistics->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Statistics Preview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php $__currentLoopData = $statistics->where('is_active', true)->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 text-center mb-3">
                            <div class="p-3 bg-dark text-white rounded">
                                <?php if($stat->icon): ?>
                                    <i class="<?php echo e($stat->icon); ?> fa-2x mb-2"></i><br>
                                <?php endif; ?>
                                <span class="h4"><?php echo e($stat->value); ?><?php echo e($stat->suffix); ?></span><br>
                                <small><?php echo e($stat->label); ?></small>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if($statistics->where('is_active', true)->count() > 4): ?>
                    <p class="text-center text-muted">
                        <small>Showing first 4 active statistics. Total: <?php echo e($statistics->where('is_active', true)->count()); ?></small>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/statistics/index.blade.php ENDPATH**/ ?>