@extends('layouts.frontend')

@section('title', $siteSettings['site_title'] ?? 'My Portfolio')

@section('content')
<!-- Modern Hero Banner -->
<div class="bgimg-1 w3-display-container modern-banner" id="home">
    <div class="banner-floating-elements">
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
        <div class="floating-shape"></div>
    </div>
    <div class="w3-display-middle banner-content">
        @if(isset($banners['hero']) && $banners['hero'])
            <h1 class="banner-title">
                {{ $banners['hero']->overlay_text ?? $banners['hero']->title }}
            </h1>
            @if($banners['hero']->subtitle)
                <p class="banner-subtitle">{{ $banners['hero']->subtitle }}</p>
            @endif
            @if($siteSettings['hero_description'])
                <p class="banner-description">{{ $siteSettings['hero_description'] }}</p>
            @else
                <p class="banner-description">Creating exceptional digital experiences through innovative design and cutting-edge technology</p>
            @endif
            <div class="banner-buttons">
                @if($banners['hero']->button_text && $banners['hero']->button_url)
                    <a href="{{ $banners['hero']->button_url }}" class="banner-btn primary">
                        <i class="fa fa-rocket"></i>
                        {{ $banners['hero']->button_text }}
                    </a>
                @else
                    <a href="#portfolio" class="banner-btn primary">
                        <i class="fa fa-eye"></i>
                        View My Work
                    </a>
                @endif
                <a href="#contact" class="banner-btn secondary">
                    <i class="fa fa-envelope"></i>
                    Get In Touch
                </a>
            </div>
        @else
            <h1 class="banner-title">
                {{ $siteSettings['site_title'] ?? $siteSettings['site_logo'] ?? 'MY PORTFOLIO' }}
            </h1>
            <p class="banner-subtitle">Creative Professional & Digital Innovator</p>
            <p class="banner-description">Creating exceptional digital experiences through innovative design and cutting-edge technology</p>
            <div class="banner-buttons">
                <a href="#portfolio" class="banner-btn primary">
                    <i class="fa fa-eye"></i>
                    View My Work
                </a>
                <a href="#contact" class="banner-btn secondary">
                    <i class="fa fa-envelope"></i>
                    Get In Touch
                </a>
            </div>
        @endif
    </div>
</div>

<!-- Modern About Section -->
<section class="modern-about-section" id="about">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="about-header w3-center w3-margin-bottom">
                <h2 class="about-section-title">{{ $siteSettings['about_title'] ?? 'About Me' }}</h2>
                <p class="about-section-subtitle">{{ $siteSettings['about_subtitle'] ?? 'Passionate about creating exceptional digital experiences' }}</p>
                <div class="about-title-divider"></div>
            </div>

            @if($aboutSections->count() > 0)
                <!-- About Content Grid -->
                <div class="modern-about-content">
                    @foreach($aboutSections as $index => $section)
                        <div class="modern-about-card" data-aos="fade-up" data-aos-delay="{{ $index * 200 }}">
                            @if($section->image)
                                <div class="about-card-layout {{ $index % 2 == 0 ? 'image-left' : 'image-right' }}">
                                    <!-- Image Section -->
                                    <div class="about-image-wrapper">
                                        <div class="about-image-container">
                                            @if(filter_var($section->image, FILTER_VALIDATE_URL))
                                                <img src="{{ $section->image }}" alt="{{ $section->title }}" class="about-image">
                                            @else
                                                <img src="{{ asset('storage/' . $section->image) }}" alt="{{ $section->title }}" class="about-image">
                                            @endif
                                            <div class="about-image-overlay">
                                                <div class="about-image-decoration"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Content Section -->
                                    <div class="about-content-wrapper">
                                        <div class="about-content-inner">
                                            <div class="about-content-badge">{{ sprintf('%02d', $index + 1) }}</div>
                                            <h3 class="about-content-title">{{ $section->title }}</h3>
                                            @if($section->subtitle)
                                                <p class="about-content-subtitle">{{ $section->subtitle }}</p>
                                            @endif
                                            <div class="about-content-text">
                                                <p>{!! nl2br(e($section->content)) !!}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <!-- Full Width Content Card -->
                                <div class="about-full-width-card">
                                    <div class="about-content-badge">{{ sprintf('%02d', $index + 1) }}</div>
                                    <h3 class="about-content-title">{{ $section->title }}</h3>
                                    @if($section->subtitle)
                                        <p class="about-content-subtitle">{{ $section->subtitle }}</p>
                                    @endif
                                    <div class="about-content-text">
                                        <p>{!! nl2br(e($section->content)) !!}</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <!-- Default About Content -->
                <div class="modern-about-content">
                    <div class="modern-about-card" data-aos="fade-up">
                        <div class="about-full-width-card">
                            <div class="about-content-badge">01</div>
                            <h3 class="about-content-title">Welcome to My Portfolio</h3>
                            <p class="about-content-subtitle">Creative Professional & Digital Innovator</p>
                            <div class="about-content-text">
                                <p>I am a passionate creative professional dedicated to delivering exceptional work and meaningful digital experiences. With years of experience in the industry, I specialize in creating innovative solutions that combine aesthetic appeal with functional excellence.</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <!-- Skills & Profile Section -->
            @if($skills->count() > 0)
                <div class="modern-skills-section">
                    <div class="skills-layout">
                        <!-- Profile Card -->
                        <div class="modern-profile-card" data-aos="fade-right">
                            <div class="profile-image-wrapper">
                                @if(filter_var($siteSettings['profile_image'] ?? '', FILTER_VALIDATE_URL))
                                    <img src="{{ $siteSettings['profile_image'] }}" alt="Profile Photo" class="profile-image">
                                @else
                                    <img src="https://www.w3schools.com/w3images/avatar_hat.jpg" alt="Profile Photo" class="profile-image">
                                @endif
                                <div class="profile-image-border"></div>
                            </div>
                            <div class="profile-info">
                                <h3 class="profile-name">{{ $siteSettings['profile_name'] ?? 'Professional Name' }}</h3>
                                <p class="profile-title">{{ $siteSettings['profile_job_title'] ?? 'Creative Professional' }}</p>
                                <p class="profile-description">{{ $siteSettings['welcome_text'] ?? 'Passionate about creating exceptional digital experiences and innovative solutions.' }}</p>
                            </div>
                        </div>
                        
                        <!-- Skills Card -->
                        <div class="modern-skills-card" data-aos="fade-left">
                            <h3 class="skills-title">{{ $siteSettings['skills_title'] ?? 'Core Expertise' }}</h3>
                            <p class="skills-subtitle">{{ $siteSettings['skills_description'] ?? 'My key areas of specialization' }}</p>
                            
                            <div class="skills-grid">
                                @foreach($skills as $skill)
                                    <div class="modern-skill-item">
                                        <div class="skill-header">
                                            <span class="skill-name">{{ $skill->name }}</span>
                                            <span class="skill-percentage">{{ $skill->percentage }}%</span>
                                        </div>
                                        <div class="skill-progress-wrapper">
                                            <div class="skill-progress-track"></div>
                                            <div class="skill-progress-bar" 
                                                 data-percentage="{{ $skill->percentage }}" 
                                                 style="background: linear-gradient(90deg, {{ $skill->color }}, {{ $skill->color }}80);">
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="about-bg-elements">
        <div class="about-bg-shape about-bg-shape-1"></div>
        <div class="about-bg-shape about-bg-shape-2"></div>
        <div class="about-bg-pattern"></div>
    </div>
</section>

<!-- Modern Statistics Section -->
@if($statistics->count() > 0)
    <section class="modern-stats-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="stats-header w3-center w3-margin-bottom">
                    <h2 class="stats-section-title">{{ $siteSettings['stats_title'] ?? 'Achievements & Milestones' }}</h2>
                    <p class="stats-section-subtitle">{{ $siteSettings['stats_subtitle'] ?? 'Numbers that showcase our journey and success story' }}</p>
                    <div class="stats-title-divider"></div>
                </div>

                <!-- Statistics Grid -->
                <div class="modern-stats-grid">
                    <!-- FontAwesome Test (remove this after testing) -->
                    <div style="display: none;">
                        <i class="fa fa-heart"></i>
                        <i class="fa fa-users"></i>
                        <i class="fa fa-bar-chart"></i>
                        <i class="fa fa-trophy"></i>
                        <i class="fa fa-calendar"></i>
                        <i class="fa fa-handshake-o"></i>
                    </div>
                    @foreach($statistics->take(4) as $index => $stat)
                        <div class="modern-stat-card" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                            <div class="stat-card-inner">
                                <!-- Icon -->
                                @if($stat->icon)
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="{{ $stat->icon }} stat-icon" title="Icon: {{ $stat->icon }}"></i>
                                    </div>
                                @else
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="fa fa-bar-chart stat-icon" title="Default Icon"></i>
                                    </div>
                                @endif
                                
                                <!-- Counter -->
                                <div class="stat-counter-wrapper">
                                    <span class="stat-counter" data-count="{{ $stat->value }}">0</span>
                                    <span class="stat-suffix">{{ $stat->suffix }}</span>
                                </div>
                                
                                <!-- Label -->
                                <h4 class="stat-label">{{ $stat->label }}</h4>
                                
                                <!-- Progress Bar -->
                                <div class="stat-progress-bar">
                                    <div class="stat-progress-fill" data-percentage="{{ min(100, ($stat->value / max($statistics->max('value'), 1)) * 100) }}"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Additional Stats Indicator -->
                @if($statistics->count() > 4)
                    <div class="additional-stats-info w3-center w3-margin-top">
                        <div class="additional-stats-badge">
                            <i class="fa fa-plus-circle"></i>
                            <span>{{ $statistics->count() - 4 }} More Achievements</span>
                        </div>
                        <p class="additional-stats-text">Discover more milestones in our complete portfolio</p>
                    </div>
                @endif
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="stats-bg-elements">
            <div class="stats-bg-circle stats-bg-circle-1"></div>
            <div class="stats-bg-circle stats-bg-circle-2"></div>
            <div class="stats-bg-circle stats-bg-circle-3"></div>
        </div>
    </section>
@endif

<!-- Second Parallax Image with Portfolio Text -->
<div class="bgimg-2 w3-display-container w3-opacity-min">
    <div class="w3-display-middle">
        @if(isset($banners['portfolio']) && $banners['portfolio'])
            <div class="w3-center" style="color: {{ $banners['portfolio']->text_color }};">
                <span class="w3-xxlarge">{{ $banners['portfolio']->overlay_text ?? $banners['portfolio']->title }}</span>
                @if($banners['portfolio']->subtitle)
                    <p class="w3-large w3-margin-top">{{ $banners['portfolio']->subtitle }}</p>
                @endif
                @if($banners['portfolio']->button_text && $banners['portfolio']->button_url)
                    <div class="w3-margin-top">
                        <a href="{{ $banners['portfolio']->button_url }}" class="w3-button w3-white w3-large w3-hover-black">
                            {{ $banners['portfolio']->button_text }}
                        </a>
                    </div>
                @endif
            </div>
        @else
            <span class="w3-xxlarge w3-text-white">PORTFOLIO</span>
        @endif
    </div>
</div>

<!-- Modern Portfolio Section -->
<section class="modern-portfolio-section" id="portfolio">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="portfolio-header w3-center w3-margin-bottom">
                <h2 class="portfolio-section-title">{{ $siteSettings['portfolio_title'] ?? 'Latest Projects' }}</h2>
                <p class="portfolio-section-subtitle">{{ $siteSettings['portfolio_subtitle'] ?? 'Discover our most recent creative work and innovative solutions' }}</p>
                <div class="portfolio-title-divider"></div>
            </div>

            @if($portfolioItems->count() > 0)
                <!-- Portfolio Grid -->
                <div class="modern-portfolio-grid">
                    @foreach($portfolioItems as $index => $item)
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="{{ $index * 150 }}">
                            <div class="portfolio-card-inner">
                                <!-- Image Container -->
                                <div class="portfolio-image-wrapper">
                                    @if(filter_var($item->image, FILTER_VALIDATE_URL))
                                        <img src="{{ $item->image }}" alt="{{ $item->title }}" class="portfolio-image" onclick="onClick(this)" data-title="{{ $item->title }}" data-description="{{ $item->description }}">
                                    @else
                                        <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->title }}" class="portfolio-image" onclick="onClick(this)" data-title="{{ $item->title }}" data-description="{{ $item->description }}">
                                    @endif
                                    
                                    <!-- Overlay -->
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title">{{ $item->title }}</h4>
                                            @if($item->category)
                                                <p class="portfolio-overlay-category">{{ $item->category }}</p>
                                            @endif
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.previousElementSibling.previousElementSibling)" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                                @if($item->url)
                                                    <a href="{{ $item->url }}" target="_blank" class="portfolio-btn portfolio-btn-link">
                                                        <i class="fa fa-external-link"></i>
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Content -->
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        @if($item->category)
                                            <span class="portfolio-category-tag">{{ $item->category }}</span>
                                        @endif
                                    </div>
                                    <h4 class="portfolio-title">{{ $item->title }}</h4>
                                    @if($item->description)
                                        <p class="portfolio-description">{{ Str::limit($item->description, 80) }}</p>
                                    @endif
                                    
                                    <!-- Action Buttons -->
                                    <div class="portfolio-actions">
                                        <button onclick="onClick(this)" class="portfolio-action-btn primary" data-image="{{ filter_var($item->image, FILTER_VALIDATE_URL) ? $item->image : asset('storage/' . $item->image) }}" data-title="{{ $item->title }}" data-description="{{ $item->description }}">
                                            <i class="fa fa-eye"></i>
                                            <span>Quick View</span>
                                        </button>
                                        @if($item->url)
                                            <a href="{{ $item->url }}" target="_blank" class="portfolio-action-btn secondary">
                                                <i class="fa fa-external-link"></i>
                                                <span>Visit</span>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- View All Button -->
                @if($allPortfolioCount > 3)
                    <div class="portfolio-view-all w3-center">
                        <a href="{{ route('portfolio.index') }}" class="modern-view-all-btn">
                            <span class="btn-text">View All Portfolio</span>
                            <span class="btn-count">({{ $allPortfolioCount }} Projects)</span>
                            <i class="fa fa-arrow-right btn-arrow"></i>
                            <div class="btn-ripple"></div>
                        </a>
                    </div>
                @endif
            @else
                <!-- Default Portfolio Items -->
                <div class="modern-portfolio-grid">
                    @php
                        $defaultItems = [
                            ['image' => 'https://www.w3schools.com/w3images/p1.jpg', 'title' => 'Mountain Mist', 'category' => 'Photography'],
                            ['image' => 'https://www.w3schools.com/w3images/p2.jpg', 'title' => 'Coffee Beans', 'category' => 'Product'],
                            ['image' => 'https://www.w3schools.com/w3images/p3.jpg', 'title' => 'Bear Closeup', 'category' => 'Wildlife']
                        ];
                    @endphp
                    @foreach($defaultItems as $index => $item)
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="{{ $index * 150 }}">
                            <div class="portfolio-card-inner">
                                <div class="portfolio-image-wrapper">
                                    <img src="{{ $item['image'] }}" alt="{{ $item['title'] }}" class="portfolio-image" onclick="onClick(this)">
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title">{{ $item['title'] }}</h4>
                                            <p class="portfolio-overlay-category">{{ $item['category'] }}</p>
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.previousElementSibling.previousElementSibling)" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        <span class="portfolio-category-tag">{{ $item['category'] }}</span>
                                    </div>
                                    <h4 class="portfolio-title">{{ $item['title'] }}</h4>
                                    <p class="portfolio-description">Sample portfolio item showcasing creative work</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="portfolio-bg-elements">
        <div class="portfolio-bg-shape portfolio-bg-shape-1"></div>
        <div class="portfolio-bg-shape portfolio-bg-shape-2"></div>
    </div>
</section>

<!-- Enhanced Modal for full size images -->
<div id="modal01" class="modern-modal" onclick="this.style.display='none'">
    <div class="modern-modal-backdrop"></div>
    <div class="modern-modal-content">
        <button class="modern-modal-close" title="Close Modal">
            <i class="fa fa-times"></i>
        </button>
        <div class="modern-modal-inner">
            <img id="img01" class="modern-modal-image">
            <div id="caption" class="modern-modal-caption"></div>
        </div>
    </div>
</div>

<!-- Third Parallax Image with Contact Text -->
<div class="bgimg-3 w3-display-container w3-opacity-min">
    <div class="w3-display-middle">
        @if(isset($banners['contact']) && $banners['contact'])
            <div class="w3-center" style="color: {{ $banners['contact']->text_color }};">
                <span class="w3-xxlarge">{{ $banners['contact']->overlay_text ?? $banners['contact']->title }}</span>
                @if($banners['contact']->subtitle)
                    <p class="w3-large w3-margin-top">{{ $banners['contact']->subtitle }}</p>
                @endif
                @if($banners['contact']->button_text && $banners['contact']->button_url)
                    <div class="w3-margin-top">
                        <a href="{{ $banners['contact']->button_url }}" class="w3-button w3-white w3-large w3-hover-black">
                            {{ $banners['contact']->button_text }}
                        </a>
                    </div>
                @endif
            </div>
        @else
            <span class="w3-xxlarge w3-text-white">CONTACT</span>
        @endif
    </div>
</div>

<!-- Modern Contact Section -->
<section class="modern-contact-section" id="contact">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="contact-header w3-center w3-margin-bottom">
                <h2 class="section-title">{{ $siteSettings['contact_title'] ?? "Let's Work Together" }}</h2>
                <p class="section-subtitle">{{ $siteSettings['contact_subtitle'] ?? "Ready to start your next project? Let's create something amazing together." }}</p>
                <div class="title-divider"></div>
            </div>

            <!-- Contact Cards Row -->
            <div class="contact-cards-row w3-margin-bottom">
                @if($contactInfo->count() > 0)
                    @php
                        $contactTypes = $contactInfo->whereIn('type', ['address', 'phone', 'email'])->sortBy('sort_order');
                    @endphp
                    @foreach($contactTypes as $contact)
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa {{ $contact->icon ?? 'fa-info' }}"></i>
                            </div>
                            <h4 class="contact-card-title">{{ $contact->label }}</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    @if($contact->type === 'email')
                                        <a href="mailto:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                    @elseif($contact->type === 'phone')
                                        <a href="tel:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                    @else
                                        <p>{!! nl2br(e($contact->value)) !!}</p>
                                    @endif
                                </div>
                                @if(in_array($contact->type, ['email', 'phone']))
                                    <div class="contact-card-action">
                                        @if($contact->type === 'email')
                                            <a href="mailto:{{ $contact->value }}" class="contact-action-btn">
                                                <i class="fa fa-envelope"></i> Send Email
                                            </a>
                                        @elseif($contact->type === 'phone')
                                            <a href="tel:{{ $contact->value }}" class="contact-action-btn">
                                                <i class="fa fa-phone"></i> Call Now
                                            </a>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                @else
                    <!-- Default Contact Cards -->
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-map-marker"></i>
                        </div>
                        <h4 class="contact-card-title">Visit Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <p>123 Business Street<br>Suite 100<br>City, State 12345</p>
                            </div>
                        </div>
                    </div>
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-phone"></i>
                        </div>
                        <h4 class="contact-card-title">Call Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <a href="tel:+1234567890" class="contact-link">+1 (234) 567-890</a>
                            </div>
                            <div class="contact-card-action">
                                <a href="tel:+1234567890" class="contact-action-btn">
                                    <i class="fa fa-phone"></i> Call Now
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="modern-contact-card">
                        <div class="contact-card-icon">
                            <i class="fa fa-envelope"></i>
                        </div>
                        <h4 class="contact-card-title">Email Us</h4>
                        <div class="contact-card-content">
                            <div class="contact-info">
                                <a href="mailto:hello@example.com" class="contact-link">hello@example.com</a>
                            </div>
                            <div class="contact-card-action">
                                <a href="mailto:hello@example.com" class="contact-action-btn">
                                    <i class="fa fa-envelope"></i> Send Email
                                </a>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Contact Form Section -->
            <div class="modern-contact-form-section w3-row">
                <div class="w3-col l6 m12 s12 w3-padding-large">
                    <div class="contact-form-intro">
                        <h3 class="form-title">{{ $siteSettings['contact_form_title'] ?? 'Send Message' }}</h3>
                        <p class="form-description">{{ $siteSettings['contact_form_message'] ?? "Have a project in mind? Let's discuss how we can work together to bring your ideas to life." }}</p>
                        
                        <!-- Business Hours -->
                        @foreach($contactInfo->where('type', 'other') as $contact)
                            <div class="business-info">
                                @if($contact->icon)
                                    <i class="fa {{ $contact->icon }} info-icon"></i>
                                @endif
                                <div class="info-content">
                                    <strong>{{ $contact->label }}</strong>
                                    <p>{!! nl2br(e($contact->value)) !!}</p>
                                </div>
                            </div>
                        @endforeach
                        
                        <!-- Response Time -->
                        <div class="response-time">
                            <i class="fa fa-clock-o info-icon"></i>
                            <div class="info-content">
                                <strong>Response Time</strong>
                                <p>{{ $siteSettings['response_time'] ?? 'I typically respond within 24 hours during business days.' }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="w3-col l6 m12 s12 w3-padding-large">
                    <div class="modern-contact-form">
                        <!-- Success/Error Messages -->
                        @if(session('success'))
                            <div class="alert alert-success">
                                <i class="fa fa-check-circle"></i>
                                <span>{{ session('success') }}</span>
                            </div>
                        @endif

                        @if($errors->any())
                            <div class="alert alert-error">
                                <i class="fa fa-exclamation-triangle"></i>
                                <ul>
                                    @foreach($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif

                        <form action="{{ route('contact.store') }}" method="POST" class="contact-form">
                            @csrf
                            <div class="form-group-row">
                                <div class="form-group">
                                    <input type="text" name="name" value="{{ old('name') }}" required 
                                           class="modern-input @error('name') error @enderror" 
                                           placeholder=" ">
                                    <label class="modern-label">Full Name *</label>
                                    <div class="input-border"></div>
                                </div>
                                <div class="form-group">
                                    <input type="email" name="email" value="{{ old('email') }}" required 
                                           class="modern-input @error('email') error @enderror" 
                                           placeholder=" ">
                                    <label class="modern-label">Email Address *</label>
                                    <div class="input-border"></div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <input type="text" name="subject" value="{{ old('subject') }}" 
                                       class="modern-input" placeholder=" ">
                                <label class="modern-label">Subject</label>
                                <div class="input-border"></div>
                            </div>
                            
                            <div class="form-group">
                                <textarea name="message" rows="5" required 
                                          class="modern-input modern-textarea @error('message') error @enderror" 
                                          placeholder=" ">{{ old('message') }}</textarea>
                                <label class="modern-label">Your Message *</label>
                                <div class="input-border"></div>
                            </div>
                            
                            <button type="submit" class="modern-submit-btn">
                                <span class="btn-text">Send Message</span>
                                <i class="fa fa-paper-plane btn-icon"></i>
                                <div class="btn-ripple"></div>
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Social Media Section -->
            @if($contactInfo->whereIn('type', ['social', 'website'])->count() > 0)
                <div class="social-connect-section w3-center w3-margin-top">
                    <h4 class="social-title">Let's Connect</h4>
                    <p class="social-subtitle">Follow me on social media for updates and behind-the-scenes content</p>
                    <div class="modern-social-links">
                        @foreach($contactInfo->where('type', 'social') as $social)
                            @if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL))
                                <a href="{{ $social->value }}" target="_blank" class="modern-social-btn" title="{{ $social->label }}">
                                    <i class="fa {{ $social->icon ?? 'fa-share-alt' }}"></i>
                                    <span class="social-label">{{ $social->label }}</span>
                                </a>
                            @endif
                        @endforeach
                        
                        @foreach($contactInfo->where('type', 'website') as $website)
                            @if($website->is_active && filter_var($website->value, FILTER_VALIDATE_URL))
                                <a href="{{ $website->value }}" target="_blank" class="modern-social-btn website-btn" title="{{ $website->label }}">
                                    <i class="fa {{ $website->icon ?? 'fa-globe' }}"></i>
                                    <span class="social-label">{{ $website->label }}</span>
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</section>

<script>
// Enhanced Modal Image Gallery
function onClick(element) {
    var modal = document.getElementById("modal01");
    var modalImg = document.getElementById("img01");
    var captionText = document.getElementById("caption");
    
    // Handle different element types
    if (element.tagName === 'IMG') {
        modalImg.src = element.src;
        captionText.innerHTML = element.alt || element.getAttribute('data-title') || '';
    } else if (element.tagName === 'BUTTON') {
        // Handle portfolio action button clicks
        var imageSrc = element.getAttribute('data-image');
        var title = element.getAttribute('data-title');
        var description = element.getAttribute('data-description');
        
        if (imageSrc) {
            modalImg.src = imageSrc;
            captionText.innerHTML = title + (description ? '<br><em>' + description + '</em>' : '');
        }
    }
    
    modal.style.display = "block";
    
    // Add smooth fade-in animation
    modal.style.opacity = "0";
    setTimeout(function() {
        modal.style.opacity = "1";
    }, 10);
}

// Enhanced modal close
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById("modal01");
    if (modal) {
        modal.addEventListener('click', function() {
            this.style.opacity = "0";
            setTimeout(function() {
                modal.style.display = "none";
            }, 300);
        });
    }
});
</script>
@endsection
