@extends('layouts.frontend')

@section('title', ($siteSettings['about_title'] ?? 'About Me') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio'))

@section('content')
<!-- Modern About Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    @if(isset($banners['about']) && $banners['about'])
        <div class="w3-display-container" style="background-image: url('{{ $banners['about']->background_image }}'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $banners['about']->overlay_text ?? $banners['about']->title }}</h1>
                @if($banners['about']->subtitle)
                    <p class="banner-subtitle">{{ $banners['about']->subtitle }}</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    @if($banners['about']->button_text && $banners['about']->button_url)
                        <a href="{{ $banners['about']->button_url }}" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            {{ $banners['about']->button_text }}
                        </a>
                    @else
                        <a href="#skills" class="banner-btn primary">
                            <i class="fa fa-cogs"></i>
                            View Skills
                        </a>
                    @endif
                    <a href="{{ route('contact') }}" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Get In Touch
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="bgimg-1 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $siteSettings['about_title'] ?? 'ABOUT ME' }}</h1>
                @if($siteSettings['about_subtitle'])
                    <p class="banner-subtitle">{{ $siteSettings['about_subtitle'] }}</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    <a href="#skills" class="banner-btn primary">
                        <i class="fa fa-cogs"></i>
                        View Skills
                    </a>
                    <a href="{{ route('contact') }}" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Get In Touch
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>

<!-- Modern About Content -->
<section class="modern-about-section">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            @if($aboutSections->count() > 0)
                <!-- About Content Grid -->
                <div class="modern-about-content">
                    @foreach($aboutSections as $index => $section)
                        <div class="modern-about-card" data-aos="fade-up" data-aos-delay="{{ $index * 200 }}">
                            @if($section->image)
                                <div class="about-card-layout {{ $index % 2 == 0 ? 'image-left' : 'image-right' }}">
                                    <!-- Image Section -->
                                    <div class="about-image-wrapper">
                                        <div class="about-image-container">
                                            @if(filter_var($section->image, FILTER_VALIDATE_URL))
                                                <img src="{{ $section->image }}" alt="{{ $section->title }}" class="about-image">
                                            @else
                                                <img src="{{ asset('storage/' . $section->image) }}" alt="{{ $section->title }}" class="about-image">
                                            @endif
                                            <div class="about-image-overlay">
                                                <div class="about-image-decoration"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Content Section -->
                                    <div class="about-content-wrapper">
                                        <div class="about-content-inner">
                                            <div class="about-content-badge">{{ sprintf('%02d', $index + 1) }}</div>
                                            <h3 class="about-content-title">{{ $section->title }}</h3>
                                            @if($section->subtitle)
                                                <p class="about-content-subtitle">{{ $section->subtitle }}</p>
                                            @endif
                                            <div class="about-content-text">
                                                <p>{!! nl2br(e($section->content)) !!}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @else
                                <!-- Full Width Content Card -->
                                <div class="about-full-width-card">
                                    <div class="about-content-badge">{{ sprintf('%02d', $index + 1) }}</div>
                                    <h3 class="about-content-title">{{ $section->title }}</h3>
                                    @if($section->subtitle)
                                        <p class="about-content-subtitle">{{ $section->subtitle }}</p>
                                    @endif
                                    <div class="about-content-text">
                                        <p>{!! nl2br(e($section->content)) !!}</p>
                                    </div>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <!-- Default About Content -->
                <div class="modern-about-content">
                    <div class="modern-about-card" data-aos="fade-up">
                        <div class="about-full-width-card">
                            <div class="about-content-badge">01</div>
                            <h3 class="about-content-title">About Me</h3>
                            <p class="about-content-subtitle">Creative Professional & Digital Innovator</p>
                            <div class="about-content-text">
                                <p>Welcome to my portfolio! I am a passionate creative professional dedicated to delivering exceptional work and meaningful experiences. With years of experience in the industry, I specialize in creating innovative solutions that combine aesthetic appeal with functional excellence.</p>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="about-bg-elements">
        <div class="about-bg-shape about-bg-shape-1"></div>
        <div class="about-bg-shape about-bg-shape-2"></div>
        <div class="about-bg-pattern"></div>
    </div>
</section>

<!-- Modern Skills & Profile Section -->
@if($skills->count() > 0)
    <section class="modern-skills-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <div class="skills-layout">
                    <!-- Profile Card -->
                    <div class="modern-profile-card" data-aos="fade-right">
                        <div class="profile-image-wrapper">
                            @if(filter_var($siteSettings['profile_image'] ?? '', FILTER_VALIDATE_URL))
                                <img src="{{ $siteSettings['profile_image'] }}" alt="Profile Photo" class="profile-image">
                            @else
                                <img src="https://www.w3schools.com/w3images/avatar_hat.jpg" alt="Profile Photo" class="profile-image">
                            @endif
                            <div class="profile-image-border"></div>
                        </div>
                        <div class="profile-info">
                            <h3 class="profile-name">{{ $siteSettings['profile_name'] ?? 'Professional Name' }}</h3>
                            <p class="profile-title">{{ $siteSettings['profile_job_title'] ?? 'Creative Professional' }}</p>
                            <p class="profile-description">{{ $siteSettings['skills_intro'] ?? 'I have developed expertise in various areas through years of dedicated practice and continuous learning.' }}</p>
                        </div>
                    </div>
                    
                    <!-- Skills Card -->
                    <div class="modern-skills-card" data-aos="fade-left">
                        <h3 class="skills-title">{{ $siteSettings['skills_title'] ?? 'Core Expertise' }}</h3>
                        <p class="skills-subtitle">{{ $siteSettings['skills_description'] ?? 'My key areas of specialization' }}</p>
                        
                        <div class="skills-grid">
                            @foreach($skills as $skill)
                                <div class="modern-skill-item">
                                    <div class="skill-header">
                                        <span class="skill-name">{{ $skill->name }}</span>
                                        <span class="skill-percentage">{{ $skill->percentage }}%</span>
                                    </div>
                                    <div class="skill-progress-wrapper">
                                        <div class="skill-progress-track"></div>
                                        <div class="skill-progress-bar" 
                                             data-percentage="{{ $skill->percentage }}" 
                                             style="background: linear-gradient(90deg, {{ $skill->color }}, {{ $skill->color }}80);">
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

<!-- Modern Statistics Section -->
@if($statistics->count() > 0)
    <section class="modern-stats-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="stats-header w3-center w3-margin-bottom">
                    <h2 class="stats-section-title">{{ $siteSettings['stats_title'] ?? 'Achievements & Milestones' }}</h2>
                    <p class="stats-section-subtitle">{{ $siteSettings['stats_subtitle'] ?? 'Numbers that showcase our journey and success story' }}</p>
                    <div class="stats-title-divider"></div>
                </div>

                <!-- Statistics Grid -->
                <div class="modern-stats-grid">
                    @foreach($statistics as $index => $stat)
                        <div class="modern-stat-card" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                            <div class="stat-card-inner">
                                <!-- Icon -->
                                @if($stat->icon)
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="{{ $stat->icon }} stat-icon" title="Icon: {{ $stat->icon }}"></i>
                                    </div>
                                @else
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="fa fa-bar-chart stat-icon" title="Default Icon"></i>
                                    </div>
                                @endif
                                
                                <!-- Counter -->
                                <div class="stat-counter-wrapper">
                                    <span class="stat-counter" data-count="{{ $stat->value }}">0</span>
                                    <span class="stat-suffix">{{ $stat->suffix }}</span>
                                </div>
                                
                                <!-- Label -->
                                <h4 class="stat-label">{{ $stat->label }}</h4>
                                
                                <!-- Progress Bar -->
                                <div class="stat-progress-bar">
                                    <div class="stat-progress-fill" data-percentage="{{ min(100, ($stat->value / max($statistics->max('value'), 1)) * 100) }}"></div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="stats-bg-elements">
            <div class="stats-bg-circle stats-bg-circle-1"></div>
            <div class="stats-bg-circle stats-bg-circle-2"></div>
            <div class="stats-bg-circle stats-bg-circle-3"></div>
        </div>
    </section>
@endif

<!-- Modern Contact Information Section -->
@if($contactInfo->count() > 0)
    <section class="modern-contact-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title">{{ $siteSettings['contact_info_title'] ?? 'GET IN TOUCH' }}</h2>
                    <p class="section-subtitle">{{ $siteSettings['contact_info_subtitle'] ?? 'Feel free to reach out through any of these channels' }}</p>
                    <div class="title-divider"></div>
                </div>

                <!-- Contact Cards Row -->
                <div class="contact-cards-row w3-margin-bottom">
                    @if($contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->count() > 0)
                        @php
                            $contactTypes = $contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->sortBy('sort_order');
                        @endphp
                        @foreach($contactTypes as $contact)
                            <div class="modern-contact-card">
                                <div class="contact-card-icon">
                                    <i class="fa {{ $contact->icon ?? 'fa-info' }}"></i>
                                </div>
                                <h4 class="contact-card-title">{{ $contact->label }}</h4>
                                <div class="contact-card-content">
                                    <div class="contact-info">
                                        @if($contact->type === 'email')
                                            <a href="mailto:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                        @elseif($contact->type === 'phone')
                                            <a href="tel:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                        @elseif($contact->type === 'website')
                                            <p>{{ $contact->value }}</p>
                                        @else
                                            <p>{!! nl2br(e($contact->value)) !!}</p>
                                        @endif
                                    </div>
                                    @if(in_array($contact->type, ['email', 'phone', 'website']))
                                        <div class="contact-card-action">
                                            @if($contact->type === 'email')
                                                <a href="mailto:{{ $contact->value }}" class="contact-action-btn">
                                                    <i class="fa fa-envelope"></i> Send Email
                                                </a>
                                            @elseif($contact->type === 'phone')
                                                <a href="tel:{{ $contact->value }}" class="contact-action-btn">
                                                    <i class="fa fa-phone"></i> Call Now
                                                </a>
                                            @elseif($contact->type === 'website')
                                                <a href="{{ $contact->value }}" target="_blank" class="contact-action-btn">
                                                    <i class="fa fa-globe"></i> Visit Website
                                                </a>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    @else
                        <!-- Default Contact Cards -->
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-map-marker"></i>
                            </div>
                            <h4 class="contact-card-title">Visit Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <p>123 Business Street<br>Suite 100<br>City, State 12345</p>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <h4 class="contact-card-title">Call Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="tel:+1234567890" class="contact-link">+1 (234) 567-890</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="tel:+1234567890" class="contact-action-btn">
                                        <i class="fa fa-phone"></i> Call Now
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-envelope"></i>
                            </div>
                            <h4 class="contact-card-title">Email Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="mailto:hello@example.com" class="contact-link">hello@example.com</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="mailto:hello@example.com" class="contact-action-btn">
                                        <i class="fa fa-envelope"></i> Send Email
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-globe"></i>
                            </div>
                            <h4 class="contact-card-title">Website</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="https://example.com" class="contact-link">www.example.com</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="https://example.com" target="_blank" class="contact-action-btn">
                                        <i class="fa fa-globe"></i> Visit Website
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
                
                <!-- Social Media Links -->
                @if($contactInfo->where('type', 'social')->count() > 0)
                    <div class="social-connect-section w3-center">
                        <h3 class="social-title">{{ $siteSettings['social_title'] ?? 'Connect With Me' }}</h3>
                        <p class="social-subtitle">{{ $siteSettings['social_description'] ?? 'Follow me on social media for updates and behind-the-scenes content' }}</p>
                        <div class="modern-social-links">
                            @foreach($contactInfo->where('type', 'social') as $social)
                                @if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL))
                                    <a href="{{ $social->value }}" target="_blank" class="modern-social-btn" title="{{ $social->label }}">
                                        <i class="fa {{ $social->icon ?? 'fa-share-alt' }}"></i>
                                        <span class="social-label">{{ $social->label }}</span>
                                    </a>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
@endif

<!-- Call to Action -->
<div class="w3-center w3-padding-64 w3-light-grey">
    <div class="w3-content">
        <h3>{{ $siteSettings['cta_title'] ?? 'Ready to Work Together?' }}</h3>
        <p class="w3-large">{{ $siteSettings['cta_description'] ?? 'Let\'s discuss your next project and bring your vision to life.' }}</p>
        <div class="w3-margin-top">
            <a href="{{ route('home') }}#contact" class="w3-button w3-black w3-large w3-padding-large w3-hover-grey">
                <i class="fa fa-envelope w3-margin-right"></i>GET IN TOUCH
            </a>
            <a href="{{ route('portfolio.index') }}" class="w3-button w3-light-grey w3-large w3-padding-large w3-margin-left w3-hover-black">
                <i class="fa fa-th w3-margin-right"></i>VIEW MY WORK
            </a>
        </div>
    </div>
</div>

<!-- Back to Home -->
<div class="w3-center w3-padding-32">
    <a href="{{ route('home') }}" class="modern-view-all-btn">
        <span class="btn-text">
            <i class="fa fa-home"></i> Back to Home
        </span>
        <span class="btn-arrow">
            <i class="fa fa-arrow-left"></i>
        </span>
        <div class="btn-ripple"></div>
    </a>
</div>
@endsection
