@extends('layouts.admin')

@section('title', 'View Skill')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Skill Details</h1>
    <div class="btn-group" role="group">
        <a href="{{ route('admin.skills.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Skills
        </a>
        <a href="{{ route('admin.skills.edit', $skill) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <h2>{{ $skill->name }}</h2>
                
                <div class="mb-4">
                    <h5>Proficiency Level</h5>
                    <div class="progress" style="height: 40px;">
                        <div class="progress-bar" role="progressbar" style="width: {{ $skill->percentage }}%; background-color: {{ $skill->color }};">
                            <span class="h5 text-white">{{ $skill->percentage }}%</span>
                        </div>
                    </div>
                    <p class="mt-2">
                        @if($skill->percentage >= 91)
                            <span class="badge bg-success fs-6">Expert Level</span>
                        @elseif($skill->percentage >= 76)
                            <span class="badge bg-info fs-6">Advanced Level</span>
                        @elseif($skill->percentage >= 51)
                            <span class="badge bg-warning fs-6">Intermediate Level</span>
                        @elseif($skill->percentage >= 26)
                            <span class="badge bg-secondary fs-6">Basic Level</span>
                        @else
                            <span class="badge bg-light text-dark fs-6">Beginner Level</span>
                        @endif
                    </p>
                </div>

                <div class="mb-3">
                    <h5>Color</h5>
                    <div class="d-flex align-items-center">
                        <div style="width: 30px; height: 30px; background: {{ $skill->color }}; border-radius: 5px; margin-right: 10px;"></div>
                        <code>{{ $skill->color }}</code>
                    </div>
                </div>

                <div class="mb-3">
                    <h5>Status</h5>
                    @if($skill->is_active)
                        <span class="badge bg-success fs-6">Active - Visible on website</span>
                    @else
                        <span class="badge bg-danger fs-6">Inactive - Hidden from website</span>
                    @endif
                </div>

                <div class="mb-3">
                    <h5>Display Order</h5>
                    <p class="text-muted">Sort Order: {{ $skill->sort_order ?? 0 }}</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Skill Information</h5>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8">{{ $skill->id }}</dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8">{{ $skill->created_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $skill->created_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Updated:</dt>
                    <dd class="col-sm-8">{{ $skill->updated_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $skill->updated_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Percentage:</dt>
                    <dd class="col-sm-8">{{ $skill->percentage }}%</dd>
                    
                    <dt class="col-sm-4">Color:</dt>
                    <dd class="col-sm-8">{{ $skill->color }}</dd>
                    
                    <dt class="col-sm-4">Sort Order:</dt>
                    <dd class="col-sm-8">{{ $skill->sort_order ?? 0 }}</dd>
                </dl>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.skills.edit', $skill) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Skill
                    </a>
                    
                    <a href="{{ route('home') }}#about" target="_blank" class="btn btn-success">
                        <i class="fas fa-eye"></i> View on Website
                    </a>
                    
                    <hr>
                    
                    <form action="{{ route('admin.skills.destroy', $skill) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this skill? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Skill
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Website Preview</h5>
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">How this appears on your website:</p>
                <div class="border rounded p-2">
                    <p class="mb-1"><strong>{{ $skill->name }}</strong></p>
                    <div style="background: #f0f0f0; height: 20px; border-radius: 10px; overflow: hidden;">
                        <div style="width: {{ $skill->percentage }}%; height: 100%; background: {{ $skill->color }}; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                            <small class="text-white" style="font-size: 10px;"><strong>{{ $skill->percentage }}%</strong></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
