@extends('layouts.admin')

@section('title', 'Site Settings')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Site Settings</h1>
    <a href="{{ route('admin.site-settings.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Setting
    </a>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Group</th>
                        <th>Key</th>
                        <th>Value</th>
                        <th>Type</th>
                        <th>Sort Order</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($settings as $setting)
                        <tr>
                            <td>
                                <span class="badge bg-secondary">{{ $setting->group }}</span>
                            </td>
                            <td><code>{{ $setting->key }}</code></td>
                            <td>
                                @if($setting->type === 'image')
                                    @if(filter_var($setting->value, FILTER_VALIDATE_URL))
                                        <img src="{{ $setting->value }}" alt="Image" class="img-thumbnail" style="max-width: 100px; max-height: 50px;">
                                    @else
                                        <span class="text-muted">{{ Str::limit($setting->value, 50) }}</span>
                                    @endif
                                @elseif($setting->type === 'textarea')
                                    <span class="text-muted">{{ Str::limit($setting->value, 100) }}</span>
                                @else
                                    {{ Str::limit($setting->value, 50) }}
                                @endif
                            </td>
                            <td>
                                <span class="badge bg-info">{{ $setting->type }}</span>
                            </td>
                            <td>{{ $setting->sort_order }}</td>
                            <td>
                                <div class="btn-group btn-group-sm" role="group">
                                    <a href="{{ route('admin.site-settings.show', $setting) }}" class="btn btn-outline-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.site-settings.edit', $setting) }}" class="btn btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form action="{{ route('admin.site-settings.destroy', $setting) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this setting?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                <p>No site settings found. <a href="{{ route('admin.site-settings.create') }}">Create your first setting</a></p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
