@extends('layouts.admin')

@section('title', 'Edit Portfolio Item')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Portfolio Item</h1>
    <a href="{{ route('admin.portfolio-items.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Portfolio
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.portfolio-items.update', $portfolioItem) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title', $portfolioItem->title) }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" name="description" rows="4">{{ old('description', $portfolioItem->description) }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Brief description of this portfolio item</div>
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Image URL <span class="text-danger">*</span></label>
                        <input type="url" class="form-control @error('image') is-invalid @enderror" 
                               id="image" name="image" value="{{ old('image', $portfolioItem->image) }}" required>
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Enter the full URL of the image (e.g., https://example.com/image.jpg)</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category" class="form-label">Category</label>
                                <input type="text" class="form-control @error('category') is-invalid @enderror" 
                                       id="category" name="category" value="{{ old('category', $portfolioItem->category) }}">
                                @error('category')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">e.g., Web Design, Photography, Graphics</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" name="sort_order" value="{{ old('sort_order', $portfolioItem->sort_order) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Lower numbers appear first</div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="url" class="form-label">External URL</label>
                        <input type="url" class="form-control @error('url') is-invalid @enderror" 
                               id="url" name="url" value="{{ old('url', $portfolioItem->url) }}">
                        @error('url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional link to the full project or external site</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $portfolioItem->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Portfolio Item
                        </button>
                        <a href="{{ route('admin.portfolio-items.index') }}" class="btn btn-secondary">Cancel</a>
                        <a href="{{ route('admin.portfolio-items.show', $portfolioItem) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Image</h5>
            </div>
            <div class="card-body">
                <div id="current-image" class="text-center mb-3">
                    @if($portfolioItem->image)
                        @if(filter_var($portfolioItem->image, FILTER_VALIDATE_URL))
                            <img src="{{ $portfolioItem->image }}" alt="{{ $portfolioItem->title }}" class="img-fluid rounded" style="max-height: 200px;">
                        @else
                            <img src="{{ asset('storage/' . $portfolioItem->image) }}" alt="{{ $portfolioItem->title }}" class="img-fluid rounded" style="max-height: 200px;">
                        @endif
                    @else
                        <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                            <i class="fas fa-image fa-3x text-muted"></i>
                        </div>
                    @endif
                </div>
                
                <div id="image-preview"></div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Item Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $portfolioItem->created_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Updated:</strong> {{ $portfolioItem->updated_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Status:</strong> 
                    @if($portfolioItem->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                </p>
                @if($portfolioItem->url)
                    <p><strong>External Link:</strong> 
                        <a href="{{ $portfolioItem->url }}" target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-external-link-alt"></i> View Project
                        </a>
                    </p>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('image').addEventListener('input', function() {
    const imageUrl = this.value;
    const previewDiv = document.getElementById('image-preview');
    
    if (imageUrl && isValidUrl(imageUrl)) {
        previewDiv.innerHTML = `
            <div class="mt-3">
                <h6>New Image Preview:</h6>
                <img src="${imageUrl}" alt="Preview" class="img-fluid rounded" style="max-height: 200px;" 
                     onerror="this.parentElement.innerHTML='<div class=\\'bg-danger text-white p-3 rounded\\'>Invalid image URL</div>'">
            </div>
        `;
    } else if (imageUrl) {
        previewDiv.innerHTML = `
            <div class="mt-3">
                <div class="bg-danger text-white p-3 rounded">Invalid image URL</div>
            </div>
        `;
    } else {
        previewDiv.innerHTML = '';
    }
});

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}
</script>
@endsection
