@extends('layouts.admin')

@section('title', 'Contact Messages')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">
        Contact Messages 
        @if($unreadCount > 0)
            <span class="badge bg-danger">{{ $unreadCount }} unread</span>
        @endif
    </h1>
    <div class="btn-group" role="group">
        <a href="{{ route('admin.contact-messages.index') }}" class="btn btn-outline-primary {{ !request('status') ? 'active' : '' }}">
            All Messages
        </a>
        <a href="{{ route('admin.contact-messages.index', ['status' => 'unread']) }}" class="btn btn-outline-warning {{ request('status') === 'unread' ? 'active' : '' }}">
            Unread ({{ $unreadCount }})
        </a>
        <a href="{{ route('admin.contact-messages.index', ['status' => 'read']) }}" class="btn btn-outline-success {{ request('status') === 'read' ? 'active' : '' }}">
            Read
        </a>
    </div>
</div>

@if($unreadCount > 0)
    <div class="mb-3">
        <form action="{{ route('admin.contact-messages.mark-all-read') }}" method="POST" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Mark all messages as read?')">
                <i class="fas fa-check-double"></i> Mark All as Read
            </button>
        </form>
    </div>
@endif

<div class="card">
    <div class="card-body">
        @if($messages->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Message Preview</th>
                            <th>Received</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($messages as $message)
                            <tr class="{{ !$message->is_read ? 'table-warning' : '' }}">
                                <td>
                                    @if($message->is_read)
                                        <span class="badge bg-success">Read</span>
                                    @else
                                        <span class="badge bg-warning">Unread</span>
                                    @endif
                                </td>
                                <td>
                                    <strong>{{ $message->name }}</strong>
                                    @if(!$message->is_read)
                                        <i class="fas fa-circle text-primary" style="font-size: 8px;"></i>
                                    @endif
                                </td>
                                <td>
                                    <a href="mailto:{{ $message->email }}">{{ $message->email }}</a>
                                </td>
                                <td>
                                    <div class="text-truncate" style="max-width: 300px;">
                                        {{ Str::limit($message->message, 100) }}
                                    </div>
                                </td>
                                <td>
                                    <small class="text-muted">
                                        {{ $message->created_at->format('M j, Y') }}<br>
                                        {{ $message->created_at->format('g:i A') }}
                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.contact-messages.show', $message) }}" 
                                           class="btn btn-outline-info" title="View Message">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form action="{{ route('admin.contact-messages.toggle-read', $message) }}" 
                                              method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" class="btn btn-outline-{{ $message->is_read ? 'warning' : 'success' }}" 
                                                    title="{{ $message->is_read ? 'Mark as Unread' : 'Mark as Read' }}">
                                                <i class="fas fa-{{ $message->is_read ? 'envelope' : 'envelope-open' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('admin.contact-messages.destroy', $message) }}" 
                                              method="POST" class="d-inline" 
                                              onsubmit="return confirm('Are you sure you want to delete this message?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                {{ $messages->withQueryString()->links() }}
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-inbox fa-3x mb-3"></i>
                <p class="h5">No contact messages found</p>
                <p>Messages sent through the contact form will appear here.</p>
            </div>
        @endif
    </div>
</div>
@endsection
