@extends('layouts.admin')

@section('title', 'Contact Information')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Information</h1>
    <a href="{{ route('admin.contact-info.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Contact Info
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($contactInfos->count() > 0)
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Icon</th>
                            <th>Type</th>
                            <th>Label</th>
                            <th>Value</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($contactInfos as $contact)
                            <tr>
                                <td>
                                    @if($contact->icon)
                                        <i class="{{ $contact->icon }} fa-lg text-primary"></i>
                                    @else
                                        <i class="fas fa-info-circle fa-lg text-muted"></i>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $contact->type === 'email' ? 'primary' : ($contact->type === 'phone' ? 'success' : ($contact->type === 'address' ? 'info' : 'secondary')) }}">
                                        {{ ucfirst($contact->type) }}
                                    </span>
                                </td>
                                <td>
                                    <strong>{{ $contact->label }}</strong>
                                </td>
                                <td>
                                    @if($contact->type === 'email')
                                        <a href="mailto:{{ $contact->value }}" class="text-decoration-none">{{ $contact->value }}</a>
                                    @elseif($contact->type === 'phone')
                                        <a href="tel:{{ $contact->value }}" class="text-decoration-none">{{ $contact->value }}</a>
                                    @elseif($contact->type === 'social' && filter_var($contact->value, FILTER_VALIDATE_URL))
                                        <a href="{{ $contact->value }}" target="_blank" class="text-decoration-none">{{ Str::limit($contact->value, 30) }}</a>
                                    @else
                                        {{ Str::limit($contact->value, 50) }}
                                    @endif
                                </td>
                                <td>
                                    @if($contact->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $contact->sort_order ?? 0 }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.contact-info.show', $contact) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.contact-info.edit', $contact) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.contact-info.destroy', $contact) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this contact information?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-address-book fa-3x mb-3"></i>
                <p class="h5">No contact information found</p>
                <p>Start by adding your first contact detail to display on your website.</p>
                <a href="{{ route('admin.contact-info.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Contact Info
                </a>
            </div>
        @endif
    </div>
</div>

@if($contactInfos->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Information Preview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($contactInfos->where('is_active', true)->take(6) as $contact)
                        <div class="col-md-4 mb-3">
                            <div class="d-flex align-items-center p-3 border rounded">
                                @if($contact->icon)
                                    <i class="{{ $contact->icon }} fa-lg text-primary me-3"></i>
                                @endif
                                <div>
                                    <strong class="d-block">{{ $contact->label }}</strong>
                                    <small class="text-muted">{{ Str::limit($contact->value, 30) }}</small>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">{{ $contactInfos->count() }}</h4>
                            <small class="text-muted">Total Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">{{ $contactInfos->where('is_active', true)->count() }}</h4>
                            <small class="text-muted">Active Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">{{ $contactInfos->whereNotNull('icon')->count() }}</h4>
                            <small class="text-muted">With Icons</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">{{ $contactInfos->groupBy('type')->count() }}</h4>
                            <small class="text-muted">Contact Types</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endsection
