@extends('layouts.admin')

@section('title', 'Edit Contact Information')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Contact Information</h1>
    <a href="{{ route('admin.contact-info.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Contact Info
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.contact-info.update', $contactInfo) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="type" class="form-label">Contact Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Select Contact Type</option>
                            <option value="address" {{ old('type', $contactInfo->type) === 'address' ? 'selected' : '' }}>Address</option>
                            <option value="phone" {{ old('type', $contactInfo->type) === 'phone' ? 'selected' : '' }}>Phone</option>
                            <option value="email" {{ old('type', $contactInfo->type) === 'email' ? 'selected' : '' }}>Email</option>
                            <option value="website" {{ old('type', $contactInfo->type) === 'website' ? 'selected' : '' }}>Website</option>
                            <option value="social" {{ old('type', $contactInfo->type) === 'social' ? 'selected' : '' }}>Social Media</option>
                            <option value="other" {{ old('type', $contactInfo->type) === 'other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('label') is-invalid @enderror" 
                               id="label" name="label" value="{{ old('label', $contactInfo->label) }}" required>
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Display label (e.g., "Office Address", "Mobile Phone", "Email")</div>
                    </div>

                    <div class="mb-3">
                        <label for="value" class="form-label">Value <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('value') is-invalid @enderror" 
                                  id="value" name="value" rows="3" required>{{ old('value', $contactInfo->value) }}</textarea>
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">The actual contact information (address, phone number, email, etc.)</div>
                    </div>

                    <div class="mb-3">
                        <label for="icon" class="form-label">Icon Class</label>
                        <input type="text" class="form-control @error('icon') is-invalid @enderror" 
                               id="icon" name="icon" value="{{ old('icon', $contactInfo->icon) }}">
                        @error('icon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">FontAwesome icon class (e.g., fa-map-marker, fa-phone, fa-envelope)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', $contactInfo->sort_order) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $contactInfo->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Contact Info
                        </button>
                        <a href="{{ route('admin.contact-info.index') }}" class="btn btn-secondary">Cancel</a>
                        <a href="{{ route('admin.contact-info.show', $contactInfo) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Contact Info</h5>
            </div>
            <div class="card-body">
                <div id="current-preview" class="text-center mb-3">
                    <div class="p-3 border rounded">
                        @if($contactInfo->icon)
                            <i class="{{ $contactInfo->icon }} fa-2x text-primary mb-2"></i>
                        @endif
                        <p class="mb-1"><strong>{{ $contactInfo->label }}</strong></p>
                        <small class="text-muted">{{ $contactInfo->value }}</small>
                    </div>
                </div>
                
                <hr>
                
                <div id="contact-preview" class="text-center">
                    <h6>Live Preview:</h6>
                    <div class="p-3 border rounded">
                        <i id="preview-icon" class="{{ $contactInfo->icon ?? 'fa-info-circle' }} fa-2x text-primary mb-2"></i>
                        <p id="preview-label" class="mb-1"><strong>{{ $contactInfo->label }}</strong></p>
                        <small id="preview-value" class="text-muted">{{ $contactInfo->value }}</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Type:</strong> <span class="badge bg-info">{{ ucfirst($contactInfo->type) }}</span></p>
                <p><strong>Created:</strong> {{ $contactInfo->created_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Updated:</strong> {{ $contactInfo->updated_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Status:</strong> 
                    @if($contactInfo->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                </p>
                
                @if($contactInfo->type === 'email')
                    <hr>
                    <a href="mailto:{{ $contactInfo->value }}" class="btn btn-sm btn-outline-primary w-100">
                        <i class="fas fa-envelope"></i> Send Email
                    </a>
                @elseif($contactInfo->type === 'phone')
                    <hr>
                    <a href="tel:{{ $contactInfo->value }}" class="btn btn-sm btn-outline-success w-100">
                        <i class="fas fa-phone"></i> Call Number
                    </a>
                @elseif($contactInfo->type === 'social' && filter_var($contactInfo->value, FILTER_VALIDATE_URL))
                    <hr>
                    <a href="{{ $contactInfo->value }}" target="_blank" class="btn btn-sm btn-outline-info w-100">
                        <i class="fas fa-external-link-alt"></i> Visit Profile
                    </a>
                @endif
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Icon Selection</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-map-marker')">
                            <i class="fa fa-map-marker"></i>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-phone')">
                            <i class="fa fa-phone"></i>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-envelope')">
                            <i class="fa fa-envelope"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updatePreview() {
    const type = document.getElementById('type').value || 'other';
    const label = document.getElementById('label').value || 'Contact Label';
    const value = document.getElementById('value').value || 'Contact Value';
    const icon = document.getElementById('icon').value || getDefaultIcon(type);
    
    document.getElementById('preview-label').innerHTML = `<strong>${label}</strong>`;
    document.getElementById('preview-value').textContent = value;
    document.getElementById('preview-icon').className = `fa ${icon} fa-2x text-primary mb-2`;
}

function setIcon(iconClass) {
    document.getElementById('icon').value = iconClass;
    updatePreview();
}

function getDefaultIcon(type) {
    const icons = {
        'address': 'fa-map-marker',
        'phone': 'fa-phone',
        'email': 'fa-envelope',
        'website': 'fa-globe',
        'social': 'fa-share-alt',
        'other': 'fa-info-circle'
    };
    return icons[type] || 'fa-info-circle';
}

// Update icon suggestion when type changes
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const iconField = document.getElementById('icon');
    
    if (!iconField.value) {
        iconField.value = getDefaultIcon(type);
    }
    
    updatePreview();
});

// Update preview when inputs change
document.getElementById('label').addEventListener('input', updatePreview);
document.getElementById('value').addEventListener('input', updatePreview);
document.getElementById('icon').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
@endsection
