@extends('layouts.admin')

@section('title', 'Create Contact Information')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create Contact Information</h1>
    <a href="{{ route('admin.contact-info.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Contact Info
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.contact-info.store') }}" method="POST">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="type" class="form-label">Contact Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Select Contact Type</option>
                            <option value="address" {{ old('type') === 'address' ? 'selected' : '' }}>Address</option>
                            <option value="phone" {{ old('type') === 'phone' ? 'selected' : '' }}>Phone</option>
                            <option value="email" {{ old('type') === 'email' ? 'selected' : '' }}>Email</option>
                            <option value="website" {{ old('type') === 'website' ? 'selected' : '' }}>Website</option>
                            <option value="social" {{ old('type') === 'social' ? 'selected' : '' }}>Social Media</option>
                            <option value="other" {{ old('type') === 'other' ? 'selected' : '' }}>Other</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('label') is-invalid @enderror" 
                               id="label" name="label" value="{{ old('label') }}" required>
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Display label (e.g., "Office Address", "Mobile Phone", "Email")</div>
                    </div>

                    <div class="mb-3">
                        <label for="value" class="form-label">Value <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('value') is-invalid @enderror" 
                                  id="value" name="value" rows="3" required>{{ old('value') }}</textarea>
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">The actual contact information (address, phone number, email, etc.)</div>
                    </div>

                    <div class="mb-3">
                        <label for="icon" class="form-label">Icon Class</label>
                        <input type="text" class="form-control @error('icon') is-invalid @enderror" 
                               id="icon" name="icon" value="{{ old('icon') }}">
                        @error('icon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">FontAwesome icon class (e.g., fa-map-marker, fa-phone, fa-envelope)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Create Contact Info
                        </button>
                        <a href="{{ route('admin.contact-info.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Preview</h5>
            </div>
            <div class="card-body">
                <div id="contact-preview" class="text-center">
                    <div class="p-3 border rounded">
                        <i id="preview-icon" class="fas fa-info-circle fa-2x text-muted mb-2"></i>
                        <p id="preview-label" class="mb-1"><strong>Contact Label</strong></p>
                        <small id="preview-value" class="text-muted">Contact Value</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Common Icons by Type</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-map-marker')">
                            <i class="fa fa-map-marker"></i><br><small>Address</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-phone')">
                            <i class="fa fa-phone"></i><br><small>Phone</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-envelope')">
                            <i class="fa fa-envelope"></i><br><small>Email</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-globe')">
                            <i class="fa fa-globe"></i><br><small>Website</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-facebook')">
                            <i class="fa fa-facebook"></i><br><small>Facebook</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-twitter')">
                            <i class="fa fa-twitter"></i><br><small>Twitter</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-instagram')">
                            <i class="fa fa-instagram"></i><br><small>Instagram</small>
                        </button>
                    </div>
                    <div class="col-6 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-linkedin')">
                            <i class="fa fa-linkedin"></i><br><small>LinkedIn</small>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Types</h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled small">
                    <li><strong>Address:</strong> Physical location or mailing address</li>
                    <li><strong>Phone:</strong> Phone numbers (mobile, office, etc.)</li>
                    <li><strong>Email:</strong> Email addresses</li>
                    <li><strong>Website:</strong> Website URLs</li>
                    <li><strong>Social:</strong> Social media profiles</li>
                    <li><strong>Other:</strong> Any other contact method</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updatePreview() {
    const type = document.getElementById('type').value || 'other';
    const label = document.getElementById('label').value || 'Contact Label';
    const value = document.getElementById('value').value || 'Contact Value';
    const icon = document.getElementById('icon').value || getDefaultIcon(type);
    
    document.getElementById('preview-label').textContent = label;
    document.getElementById('preview-value').textContent = value;
    document.getElementById('preview-icon').className = `fa ${icon} fa-2x text-primary mb-2`;
}

function setIcon(iconClass) {
    document.getElementById('icon').value = iconClass;
    updatePreview();
}

function getDefaultIcon(type) {
    const icons = {
        'address': 'fa-map-marker',
        'phone': 'fa-phone',
        'email': 'fa-envelope',
        'website': 'fa-globe',
        'social': 'fa-share-alt',
        'other': 'fa-info-circle'
    };
    return icons[type] || 'fa-info-circle';
}

// Update icon suggestion when type changes
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const iconField = document.getElementById('icon');
    
    if (!iconField.value) {
        iconField.value = getDefaultIcon(type);
    }
    
    updatePreview();
});

// Update preview when inputs change
document.getElementById('label').addEventListener('input', updatePreview);
document.getElementById('value').addEventListener('input', updatePreview);
document.getElementById('icon').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
@endsection
