@extends('layouts.admin')

@section('title', 'Edit Banner')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Banner</h1>
    <a href="{{ route('admin.banners.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Banners
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.banners.update', $banner) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Banner Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title', $banner->title) }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Internal title for admin reference</div>
                    </div>

                    <div class="mb-3">
                        <label for="position" class="form-label">Banner Position <span class="text-danger">*</span></label>
                        <select class="form-select @error('position') is-invalid @enderror" id="position" name="position" required>
                            <option value="">Select Position</option>
                            <option value="hero" {{ old('position', $banner->position) === 'hero' ? 'selected' : '' }}>Hero Section (Homepage top)</option>
                            <option value="portfolio" {{ old('position', $banner->position) === 'portfolio' ? 'selected' : '' }}>Portfolio Section (Homepage)</option>
                            <option value="contact" {{ old('position', $banner->position) === 'contact' ? 'selected' : '' }}>Contact Section (Homepage)</option>
                            <option value="about" {{ old('position', $banner->position) === 'about' ? 'selected' : '' }}>About Page Header</option>
                            <option value="portfolio-page" {{ old('position', $banner->position) === 'portfolio-page' ? 'selected' : '' }}>Portfolio Page Header</option>
                            <option value="contact-page" {{ old('position', $banner->position) === 'contact-page' ? 'selected' : '' }}>Contact Page Header</option>
                            <option value="custom" {{ old('position', $banner->position) === 'custom' ? 'selected' : '' }}>Custom Section</option>
                        </select>
                        @error('position')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="background_image" class="form-label">Background Image URL <span class="text-danger">*</span></label>
                        <input type="url" class="form-control @error('background_image') is-invalid @enderror" 
                               id="background_image" name="background_image" value="{{ old('background_image', $banner->background_image) }}" required>
                        @error('background_image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">High-resolution image URL for the parallax background</div>
                    </div>

                    <div class="mb-3">
                        <label for="overlay_text" class="form-label">Overlay Text</label>
                        <input type="text" class="form-control @error('overlay_text') is-invalid @enderror" 
                               id="overlay_text" name="overlay_text" value="{{ old('overlay_text', $banner->overlay_text) }}">
                        @error('overlay_text')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Main text displayed on the banner</div>
                    </div>

                    <div class="mb-3">
                        <label for="subtitle" class="form-label">Subtitle</label>
                        <input type="text" class="form-control @error('subtitle') is-invalid @enderror" 
                               id="subtitle" name="subtitle" value="{{ old('subtitle', $banner->subtitle) }}">
                        @error('subtitle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional subtitle text</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="button_text" class="form-label">Button Text</label>
                                <input type="text" class="form-control @error('button_text') is-invalid @enderror" 
                                       id="button_text" name="button_text" value="{{ old('button_text', $banner->button_text) }}">
                                @error('button_text')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Optional button text</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="button_url" class="form-label">Button URL</label>
                                <input type="text" class="form-control @error('button_url') is-invalid @enderror" 
                                       id="button_url" name="button_url" value="{{ old('button_url', $banner->button_url) }}">
                                @error('button_url')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">URL or anchor (e.g., #portfolio, /contact)</div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="text_color" class="form-label">Text Color <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color @error('text_color') is-invalid @enderror" 
                                           id="text_color" name="text_color" value="{{ old('text_color', $banner->text_color) }}" required style="max-width: 60px;">
                                    <input type="text" class="form-control" id="text-color-hex" value="{{ old('text_color', $banner->text_color) }}" readonly>
                                </div>
                                @error('text_color')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" name="sort_order" value="{{ old('sort_order', $banner->sort_order) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Lower numbers appear first</div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $banner->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Banner
                        </button>
                        <a href="{{ route('admin.banners.index') }}" class="btn btn-secondary">Cancel</a>
                        <a href="{{ route('admin.banners.show', $banner) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Banner</h5>
            </div>
            <div class="card-body">
                <div class="position-relative mb-3" style="height: 150px; border-radius: 8px; overflow: hidden;">
                    @if(filter_var($banner->background_image, FILTER_VALIDATE_URL))
                        <img src="{{ $banner->background_image }}" alt="{{ $banner->title }}" class="w-100 h-100" style="object-fit: cover;">
                    @else
                        <img src="{{ asset('storage/' . $banner->background_image) }}" alt="{{ $banner->title }}" class="w-100 h-100" style="object-fit: cover;">
                    @endif
                    <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" style="background: rgba(0,0,0,0.4);">
                        <div class="text-center" style="color: {{ $banner->text_color }};">
                            <h6 class="mb-0">{{ $banner->overlay_text ?? $banner->title }}</h6>
                        </div>
                    </div>
                </div>
                
                <div id="banner-preview" class="position-relative" style="height: 150px; background: #f8f9fa; border-radius: 8px; overflow: hidden;">
                    <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center">
                        <div class="text-center">
                            <h6>Live Preview</h6>
                            <small class="text-muted">Updates as you type</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Banner Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $banner->created_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Updated:</strong> {{ $banner->updated_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Position:</strong> <span class="badge bg-info">{{ ucfirst($banner->position) }}</span></p>
                <p><strong>Status:</strong> 
                    @if($banner->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updatePreview() {
    const backgroundImage = document.getElementById('background_image').value;
    const overlayText = document.getElementById('overlay_text').value;
    const textColor = document.getElementById('text_color').value;
    const subtitle = document.getElementById('subtitle').value;
    const previewDiv = document.getElementById('banner-preview');
    
    if (backgroundImage && isValidUrl(backgroundImage)) {
        previewDiv.innerHTML = `
            <div class="position-absolute top-0 start-0 w-100 h-100" 
                 style="background-image: url('${backgroundImage}'); background-size: cover; background-position: center;">
                <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" 
                     style="background: rgba(0,0,0,0.4);">
                    <div class="text-center" style="color: ${textColor};">
                        <h6 class="mb-0">${overlayText || 'BANNER TEXT'}</h6>
                        ${subtitle ? `<small>${subtitle}</small>` : ''}
                    </div>
                </div>
            </div>
        `;
    } else {
        previewDiv.innerHTML = `
            <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center">
                <div class="text-center">
                    <h6>Live Preview</h6>
                    <small class="text-muted">Enter image URL to see preview</small>
                </div>
            </div>
        `;
    }
}

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}

// Update color hex display when color picker changes
document.getElementById('text_color').addEventListener('change', function() {
    document.getElementById('text-color-hex').value = this.value;
    updatePreview();
});

// Update preview when inputs change
document.getElementById('background_image').addEventListener('input', updatePreview);
document.getElementById('overlay_text').addEventListener('input', updatePreview);
document.getElementById('subtitle').addEventListener('input', updatePreview);
document.getElementById('text_color').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
@endsection
