@extends('layouts.admin')

@section('title', 'View About Section')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">About Section Details</h1>
    <div class="btn-group" role="group">
        <a href="{{ route('admin.about-sections.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to About Sections
        </a>
        <a href="{{ route('admin.about-sections.edit', $aboutSection) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <h2>{{ $aboutSection->title }}</h2>
                        
                        @if($aboutSection->subtitle)
                            <p class="lead text-muted">{{ $aboutSection->subtitle }}</p>
                        @endif

                        <div class="mb-3">
                            <h5>Status</h5>
                            @if($aboutSection->is_active)
                                <span class="badge bg-success fs-6">Active - Visible on website</span>
                            @else
                                <span class="badge bg-danger fs-6">Inactive - Hidden from website</span>
                            @endif
                        </div>

                        @if($aboutSection->image)
                            <div class="mb-4">
                                <h5>Image</h5>
                                @if(filter_var($aboutSection->image, FILTER_VALIDATE_URL))
                                    <img src="{{ $aboutSection->image }}" alt="{{ $aboutSection->title }}" class="img-fluid rounded" style="max-width: 400px;">
                                @else
                                    <img src="{{ asset('storage/' . $aboutSection->image) }}" alt="{{ $aboutSection->title }}" class="img-fluid rounded" style="max-width: 400px;">
                                @endif
                            </div>
                        @endif

                        <div class="mb-3">
                            <h5>Content</h5>
                            <div class="border rounded p-3 bg-light">
                                {!! nl2br(e($aboutSection->content)) !!}
                            </div>
                        </div>

                        <div class="mb-3">
                            <h5>Display Order</h5>
                            <p class="text-muted">Sort Order: {{ $aboutSection->sort_order ?? 0 }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Section Information</h5>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8">{{ $aboutSection->id }}</dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8">{{ $aboutSection->created_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $aboutSection->created_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Updated:</dt>
                    <dd class="col-sm-8">{{ $aboutSection->updated_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $aboutSection->updated_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Sort Order:</dt>
                    <dd class="col-sm-8">{{ $aboutSection->sort_order ?? 0 }}</dd>
                    
                    <dt class="col-sm-4">Word Count:</dt>
                    <dd class="col-sm-8">{{ str_word_count($aboutSection->content) }} words</dd>
                    
                    <dt class="col-sm-4">Characters:</dt>
                    <dd class="col-sm-8">{{ strlen($aboutSection->content) }} characters</dd>
                </dl>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.about-sections.edit', $aboutSection) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Section
                    </a>
                    
                    <a href="{{ route('home') }}#about" target="_blank" class="btn btn-success">
                        <i class="fas fa-eye"></i> View on Website
                    </a>
                    
                    <hr>
                    
                    <form action="{{ route('admin.about-sections.destroy', $aboutSection) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this about section? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Section
                        </button>
                    </form>
                </div>
            </div>
        </div>

        @if($aboutSection->image)
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Image Details</h5>
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">Image URL:</p>
                <p class="small"><code>{{ $aboutSection->image }}</code></p>
                
                <button class="btn btn-sm btn-outline-secondary" onclick="copyToClipboard('{{ $aboutSection->image }}')">
                    <i class="fas fa-copy"></i> Copy URL
                </button>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@section('scripts')
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Image URL copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>
@endsection
