@extends('layouts.admin')

@section('title', 'Edit About Section')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit About Section</h1>
    <a href="{{ route('admin.about-sections.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to About Sections
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.about-sections.update', $aboutSection) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title', $aboutSection->title) }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="subtitle" class="form-label">Subtitle</label>
                        <input type="text" class="form-control @error('subtitle') is-invalid @enderror" 
                               id="subtitle" name="subtitle" value="{{ old('subtitle', $aboutSection->subtitle) }}">
                        @error('subtitle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional subtitle or tagline</div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Content <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('content') is-invalid @enderror" 
                                  id="content" name="content" rows="8" required>{{ old('content', $aboutSection->content) }}</textarea>
                        @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Main content for this about section. You can use line breaks for paragraphs.</div>
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Image URL</label>
                        <input type="url" class="form-control @error('image') is-invalid @enderror" 
                               id="image" name="image" value="{{ old('image', $aboutSection->image) }}">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional image URL (e.g., https://example.com/image.jpg)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', $aboutSection->sort_order) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $aboutSection->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update About Section
                        </button>
                        <a href="{{ route('admin.about-sections.index') }}" class="btn btn-secondary">Cancel</a>
                        <a href="{{ route('admin.about-sections.show', $aboutSection) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Image</h5>
            </div>
            <div class="card-body">
                <div id="current-image" class="text-center mb-3">
                    @if($aboutSection->image)
                        @if(filter_var($aboutSection->image, FILTER_VALIDATE_URL))
                            <img src="{{ $aboutSection->image }}" alt="{{ $aboutSection->title }}" class="img-fluid rounded" style="max-height: 200px;">
                        @else
                            <img src="{{ asset('storage/' . $aboutSection->image) }}" alt="{{ $aboutSection->title }}" class="img-fluid rounded" style="max-height: 200px;">
                        @endif
                    @else
                        <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                            <i class="fas fa-user fa-3x text-muted"></i>
                        </div>
                    @endif
                </div>
                
                <div id="image-preview"></div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Section Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $aboutSection->created_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Updated:</strong> {{ $aboutSection->updated_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Status:</strong> 
                    @if($aboutSection->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                </p>
                <p><strong>Word Count:</strong> {{ str_word_count($aboutSection->content) }} words</p>
                <p><strong>Character Count:</strong> {{ strlen($aboutSection->content) }} characters</p>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('image').addEventListener('input', function() {
    const imageUrl = this.value;
    const previewDiv = document.getElementById('image-preview');
    
    if (imageUrl && isValidUrl(imageUrl)) {
        previewDiv.innerHTML = `
            <div class="mt-3">
                <h6>New Image Preview:</h6>
                <img src="${imageUrl}" alt="Preview" class="img-fluid rounded" style="max-height: 200px;" 
                     onerror="this.parentElement.innerHTML='<div class=\\'bg-danger text-white p-3 rounded\\'>Invalid image URL</div>'">
            </div>
        `;
    } else if (imageUrl) {
        previewDiv.innerHTML = `
            <div class="mt-3">
                <div class="bg-danger text-white p-3 rounded">Invalid image URL</div>
            </div>
        `;
    } else {
        previewDiv.innerHTML = '';
    }
});

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}
</script>
@endsection
