<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Banner extends Model
{
    protected $fillable = [
        'title',
        'subtitle',
        'background_image',
        'text_color',
        'position',
        'overlay_text',
        'button_text',
        'button_url',
        'is_active',
        'sort_order'
    ];

    protected $casts = [
        'is_active' => 'boolean'
    ];

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order')->orderBy('created_at');
    }

    public function scopeByPosition($query, $position)
    {
        return $query->where('position', $position);
    }

    // Get banner for specific position
    public static function getForPosition($position)
    {
        return self::active()->byPosition($position)->ordered()->first();
    }
}
