<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PortfolioItem;
use App\Models\SiteSetting;
use App\Models\Banner;

class PortfolioController extends Controller
{
    public function index(Request $request)
    {
        $query = PortfolioItem::active()->ordered();
        
        // Filter by category if provided
        if ($request->has('category') && $request->category) {
            $query->where('category', $request->category);
        }

            $portfolioItems = $query->paginate(9);
        $categories = PortfolioItem::active()
            ->whereNotNull('category')
            ->pluck('category')
            ->unique()
            ->sort()
            ->values();

        $siteSettings = $this->getSiteSettings();
        $banners = [
            'portfolio' => Banner::getForPosition('portfolio-page'),
        ];

        return view('frontend.portfolio', compact('portfolioItems', 'categories', 'siteSettings', 'banners'));
    }

    public function show(PortfolioItem $portfolioItem)
    {
        if (!$portfolioItem->is_active) {
            abort(404);
        }

        $siteSettings = $this->getSiteSettings();
        $banners = [
            'portfolio' => Banner::getForPosition('portfolio-page'),
        ];
        $relatedItems = PortfolioItem::active()
            ->where('id', '!=', $portfolioItem->id)
            ->when($portfolioItem->category, function($query) use ($portfolioItem) {
                $query->where('category', $portfolioItem->category);
            })
            ->ordered()
            ->limit(3)
            ->get();

        return view('frontend.portfolio-single', compact('portfolioItem', 'relatedItems', 'siteSettings', 'banners'));
    }

    private function getSiteSettings()
    {
        $settings = SiteSetting::all();
        $data = [];
        
        foreach ($settings as $setting) {
            $data[$setting->key] = $setting->value;
        }
        
        return $data;
    }
}
