<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SiteSetting;
use App\Models\AboutSection;
use App\Models\PortfolioItem;
use App\Models\Skill;
use App\Models\Statistic;
use App\Models\ContactInfo;
use App\Models\Banner;

class HomeController extends Controller
{
    public function index()
    {
        $data = [
            'siteSettings' => $this->getSiteSettings(),
            'aboutSections' => AboutSection::active()->ordered()->get(),
                'portfolioItems' => PortfolioItem::active()->ordered()->limit(3)->get(),
            'allPortfolioCount' => PortfolioItem::active()->count(),
            'skills' => Skill::active()->ordered()->get(),
            'statistics' => Statistic::active()->ordered()->get(),
            'contactInfo' => ContactInfo::active()->ordered()->get(),
            'banners' => [
                'hero' => Banner::getForPosition('hero'),
                'portfolio' => Banner::getForPosition('portfolio'),
                'contact' => Banner::getForPosition('contact'),
            ],
        ];

        return view('frontend.home', $data);
    }

    private function getSiteSettings()
    {
        $settings = SiteSetting::all();
        $data = [];
        
        foreach ($settings as $setting) {
            $data[$setting->key] = $setting->value;
        }
        
        return $data;
    }
}
