<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SiteSetting;
use App\Models\AboutSection;
use App\Models\PortfolioItem;
use App\Models\Skill;
use App\Models\Statistic;
use App\Models\ContactInfo;
use App\Models\ContactMessage;
use App\Models\Banner;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'site_settings' => SiteSetting::count(),
            'about_sections' => AboutSection::count(),
            'active_about_sections' => AboutSection::active()->count(),
            'portfolio_items' => PortfolioItem::count(),
            'skills' => Skill::count(),
            'statistics' => Statistic::count(),
            'contact_info' => ContactInfo::count(),
            'contact_messages' => ContactMessage::count(),
            'unread_messages' => ContactMessage::unread()->count(),
            'banners' => Banner::count(),
            'active_banners' => Banner::active()->count(),
        ];

        return view('admin.dashboard', compact('stats'));
    }
}
