<?php $__env->startSection('title', ($siteSettings['portfolio_title'] ?? 'Portfolio') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio')); ?>

<?php $__env->startSection('content'); ?>
<!-- Modern Portfolio Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    <?php if(isset($banners['portfolio']) && $banners['portfolio']): ?>
        <div class="w3-display-container" style="background-image: url('<?php echo e($banners['portfolio']->background_image); ?>'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($banners['portfolio']->overlay_text ?? $banners['portfolio']->title); ?></h1>
                <?php if($banners['portfolio']->subtitle): ?>
                    <p class="banner-subtitle"><?php echo e($banners['portfolio']->subtitle); ?></p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <?php if($banners['portfolio']->button_text && $banners['portfolio']->button_url): ?>
                        <a href="<?php echo e($banners['portfolio']->button_url); ?>" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            <?php echo e($banners['portfolio']->button_text); ?>

                        </a>
                    <?php else: ?>
                        <a href="#portfolio-grid" class="banner-btn primary">
                            <i class="fa fa-th"></i>
                            Browse Projects
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('contact')); ?>" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Start a Project
                    </a>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bgimg-2 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($siteSettings['portfolio_title'] ?? 'MY PORTFOLIO'); ?></h1>
                <?php if($siteSettings['portfolio_subtitle']): ?>
                    <p class="banner-subtitle"><?php echo e($siteSettings['portfolio_subtitle']); ?></p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <a href="#portfolio-grid" class="banner-btn primary">
                        <i class="fa fa-th"></i>
                        Browse Projects
                    </a>
                    <a href="<?php echo e(route('contact')); ?>" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Start a Project
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Modern Portfolio Section -->
<section class="modern-portfolio-section" id="portfolio-grid">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="portfolio-header w3-center w3-margin-bottom">
                <h2 class="portfolio-section-title"><?php echo e($siteSettings['portfolio_title'] ?? 'My Portfolio'); ?></h2>
                <p class="portfolio-section-subtitle"><?php echo e($siteSettings['portfolio_subtitle'] ?? 'Explore my creative work and innovative projects'); ?></p>
                <div class="portfolio-title-divider"></div>
            </div>

            <!-- Modern Category Filter -->
            <?php if($categories->count() > 0): ?>
                <div class="modern-filter-section w3-center w3-margin-bottom">
                    <div class="modern-filter-tabs">
                        <a href="<?php echo e(route('portfolio.index')); ?>" class="modern-filter-tab <?php echo e(!request('category') ? 'active' : ''); ?>">
                            <span>All Projects</span>
                        </a>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('portfolio.index', ['category' => $category])); ?>" 
                               class="modern-filter-tab <?php echo e(request('category') === $category ? 'active' : ''); ?>">
                                <span><?php echo e($category); ?></span>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <?php if($portfolioItems->count() > 0): ?>
                <!-- Modern Portfolio Grid -->
                <div class="modern-portfolio-grid">
                    <?php $__currentLoopData = $portfolioItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                            <div class="portfolio-card-inner">
                                <!-- Image Container -->
                                <div class="portfolio-image-wrapper">
                                    <?php if(filter_var($item->image, FILTER_VALIDATE_URL)): ?>
                                        <img src="<?php echo e($item->image); ?>" alt="<?php echo e($item->title); ?>" class="portfolio-image" onclick="onClick(this)" data-title="<?php echo e($item->title); ?>" data-description="<?php echo e($item->description); ?>">
                                    <?php else: ?>
                                        <img src="<?php echo e(asset('storage/' . $item->image)); ?>" alt="<?php echo e($item->title); ?>" class="portfolio-image" onclick="onClick(this)" data-title="<?php echo e($item->title); ?>" data-description="<?php echo e($item->description); ?>">
                                    <?php endif; ?>
                                    
                                    <!-- Overlay -->
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title"><?php echo e($item->title); ?></h4>
                                            <?php if($item->category): ?>
                                                <p class="portfolio-overlay-category"><?php echo e($item->category); ?></p>
                                            <?php endif; ?>
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.parentElement.parentElement.parentElement.querySelector('.portfolio-image'))" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                                <?php if($item->url): ?>
                                                    <a href="<?php echo e($item->url); ?>" target="_blank" class="portfolio-btn portfolio-btn-link">
                                                        <i class="fa fa-external-link"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="<?php echo e(route('portfolio.show', $item)); ?>" class="portfolio-btn portfolio-btn-details">
                                                    <i class="fa fa-info"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Content -->
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        <?php if($item->category): ?>
                                            <span class="portfolio-category-tag"><?php echo e($item->category); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <h4 class="portfolio-title"><?php echo e($item->title); ?></h4>
                                    <?php if($item->description): ?>
                                        <p class="portfolio-description"><?php echo e(Str::limit($item->description, 80)); ?></p>
                                    <?php endif; ?>
                                    
                                    <!-- Action Buttons -->
                                    <div class="portfolio-actions">
                                        <a href="<?php echo e(route('portfolio.show', $item)); ?>" class="portfolio-action-btn primary">
                                            <i class="fa fa-eye"></i>
                                            <span>View Details</span>
                                        </a>
                                        <?php if($item->url): ?>
                                            <a href="<?php echo e($item->url); ?>" target="_blank" class="portfolio-action-btn secondary">
                                                <i class="fa fa-external-link"></i>
                                                <span>Visit</span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <!-- Modern Pagination -->
                <?php if($portfolioItems->hasPages()): ?>
                    <div class="modern-pagination w3-center">
                        <div class="pagination-wrapper">
                            
                            <?php if($portfolioItems->onFirstPage()): ?>
                                <span class="pagination-btn disabled">
                                    <i class="fa fa-chevron-left"></i>
                                </span>
                            <?php else: ?>
                                <a href="<?php echo e($portfolioItems->previousPageUrl()); ?>" class="pagination-btn">
                                    <i class="fa fa-chevron-left"></i>
                                </a>
                            <?php endif; ?>

                            
                            <?php $__currentLoopData = $portfolioItems->getUrlRange(1, $portfolioItems->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page == $portfolioItems->currentPage()): ?>
                                    <span class="pagination-btn active"><?php echo e($page); ?></span>
                                <?php else: ?>
                                    <a href="<?php echo e($url); ?>" class="pagination-btn"><?php echo e($page); ?></a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            <?php if($portfolioItems->hasMorePages()): ?>
                                <a href="<?php echo e($portfolioItems->nextPageUrl()); ?>" class="pagination-btn">
                                    <i class="fa fa-chevron-right"></i>
                                </a>
                            <?php else: ?>
                                <span class="pagination-btn disabled">
                                    <i class="fa fa-chevron-right"></i>
                                </span>
                            <?php endif; ?>
                        </div>
                        
                        <p class="pagination-info">
                            Showing <?php echo e($portfolioItems->firstItem()); ?> to <?php echo e($portfolioItems->lastItem()); ?> of <?php echo e($portfolioItems->total()); ?> projects
                        </p>
                    </div>
                <?php endif; ?>
            <?php else: ?>
                <!-- Empty State -->
                <div class="portfolio-empty-state w3-center">
                    <div class="empty-state-icon">
                        <i class="fa fa-folder-open"></i>
                    </div>
                    <h3 class="empty-state-title">No Projects Found</h3>
                    <p class="empty-state-description">
                        <?php if(request('category')): ?>
                            No projects found in the "<?php echo e(request('category')); ?>" category.
                        <?php else: ?>
                            No portfolio items are currently available.
                        <?php endif; ?>
                    </p>
                    <?php if(request('category')): ?>
                        <a href="<?php echo e(route('portfolio.index')); ?>" class="modern-view-all-btn">
                            <span class="btn-text">View All Projects</span>
                            <i class="fa fa-arrow-left btn-arrow"></i>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <!-- Back to Home -->
            <div class="portfolio-navigation w3-center">
                <a href="<?php echo e(route('home')); ?>" class="modern-view-all-btn">
                    <i class="fa fa-home btn-arrow"></i>
                    <span class="btn-text">Back to Home</span>
                </a>
            </div>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="portfolio-bg-elements">
        <div class="portfolio-bg-shape portfolio-bg-shape-1"></div>
        <div class="portfolio-bg-shape portfolio-bg-shape-2"></div>
    </div>
</section>

<!-- Enhanced Modal for full size images -->
<div id="modal01" class="modern-modal" onclick="this.style.display='none'">
    <div class="modern-modal-backdrop"></div>
    <div class="modern-modal-content">
        <button class="modern-modal-close" title="Close Modal">
            <i class="fa fa-times"></i>
        </button>
        <div class="modern-modal-inner">
            <img id="img01" class="modern-modal-image">
            <div id="caption" class="modern-modal-caption"></div>
        </div>
    </div>
</div>

<script>
// Enhanced Modal Image Gallery
function onClick(element) {
    var modal = document.getElementById("modal01");
    var modalImg = document.getElementById("img01");
    var captionText = document.getElementById("caption");
    
    modalImg.src = element.src;
    captionText.innerHTML = element.alt || element.getAttribute('data-title') || '';
    
    modal.style.display = "block";
    
    // Add smooth fade-in animation
    modal.style.opacity = "0";
    setTimeout(function() {
        modal.style.opacity = "1";
    }, 10);
}

// Enhanced modal close
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById("modal01");
    if (modal) {
        modal.addEventListener('click', function() {
            this.style.opacity = "0";
            setTimeout(function() {
                modal.style.display = "none";
            }, 300);
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/frontend/portfolio.blade.php ENDPATH**/ ?>