<?php $__env->startSection('title', 'Edit Contact Information'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Contact Information</h1>
    <a href="<?php echo e(route('admin.contact-info.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Contact Info
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.contact-info.update', $contactInfo)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>
                    
                    <div class="mb-3">
                        <label for="type" class="form-label">Contact Type <span class="text-danger">*</span></label>
                        <select class="form-select <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="type" name="type" required>
                            <option value="">Select Contact Type</option>
                            <option value="address" <?php echo e(old('type', $contactInfo->type) === 'address' ? 'selected' : ''); ?>>Address</option>
                            <option value="phone" <?php echo e(old('type', $contactInfo->type) === 'phone' ? 'selected' : ''); ?>>Phone</option>
                            <option value="email" <?php echo e(old('type', $contactInfo->type) === 'email' ? 'selected' : ''); ?>>Email</option>
                            <option value="website" <?php echo e(old('type', $contactInfo->type) === 'website' ? 'selected' : ''); ?>>Website</option>
                            <option value="social" <?php echo e(old('type', $contactInfo->type) === 'social' ? 'selected' : ''); ?>>Social Media</option>
                            <option value="other" <?php echo e(old('type', $contactInfo->type) === 'other' ? 'selected' : ''); ?>>Other</option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="mb-3">
                        <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="label" name="label" value="<?php echo e(old('label', $contactInfo->label)); ?>" required>
                        <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">Display label (e.g., "Office Address", "Mobile Phone", "Email")</div>
                    </div>

                    <div class="mb-3">
                        <label for="value" class="form-label">Value <span class="text-danger">*</span></label>
                        <textarea class="form-control <?php $__errorArgs = ['value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="value" name="value" rows="3" required><?php echo e(old('value', $contactInfo->value)); ?></textarea>
                        <?php $__errorArgs = ['value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">The actual contact information (address, phone number, email, etc.)</div>
                    </div>

                    <div class="mb-3">
                        <label for="icon" class="form-label">Icon Class</label>
                        <input type="text" class="form-control <?php $__errorArgs = ['icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="icon" name="icon" value="<?php echo e(old('icon', $contactInfo->icon)); ?>">
                        <?php $__errorArgs = ['icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">FontAwesome icon class (e.g., fa-map-marker, fa-phone, fa-envelope)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="sort_order" name="sort_order" value="<?php echo e(old('sort_order', $contactInfo->sort_order)); ?>">
                        <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" <?php echo e(old('is_active', $contactInfo->is_active) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Contact Info
                        </button>
                        <a href="<?php echo e(route('admin.contact-info.index')); ?>" class="btn btn-secondary">Cancel</a>
                        <a href="<?php echo e(route('admin.contact-info.show', $contactInfo)); ?>" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Contact Info</h5>
            </div>
            <div class="card-body">
                <div id="current-preview" class="text-center mb-3">
                    <div class="p-3 border rounded">
                        <?php if($contactInfo->icon): ?>
                            <i class="<?php echo e($contactInfo->icon); ?> fa-2x text-primary mb-2"></i>
                        <?php endif; ?>
                        <p class="mb-1"><strong><?php echo e($contactInfo->label); ?></strong></p>
                        <small class="text-muted"><?php echo e($contactInfo->value); ?></small>
                    </div>
                </div>
                
                <hr>
                
                <div id="contact-preview" class="text-center">
                    <h6>Live Preview:</h6>
                    <div class="p-3 border rounded">
                        <i id="preview-icon" class="<?php echo e($contactInfo->icon ?? 'fa-info-circle'); ?> fa-2x text-primary mb-2"></i>
                        <p id="preview-label" class="mb-1"><strong><?php echo e($contactInfo->label); ?></strong></p>
                        <small id="preview-value" class="text-muted"><?php echo e($contactInfo->value); ?></small>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Type:</strong> <span class="badge bg-info"><?php echo e(ucfirst($contactInfo->type)); ?></span></p>
                <p><strong>Created:</strong> <?php echo e($contactInfo->created_at->format('F j, Y \a\t g:i A')); ?></p>
                <p><strong>Updated:</strong> <?php echo e($contactInfo->updated_at->format('F j, Y \a\t g:i A')); ?></p>
                <p><strong>Status:</strong> 
                    <?php if($contactInfo->is_active): ?>
                        <span class="badge bg-success">Active</span>
                    <?php else: ?>
                        <span class="badge bg-danger">Inactive</span>
                    <?php endif; ?>
                </p>
                
                <?php if($contactInfo->type === 'email'): ?>
                    <hr>
                    <a href="mailto:<?php echo e($contactInfo->value); ?>" class="btn btn-sm btn-outline-primary w-100">
                        <i class="fas fa-envelope"></i> Send Email
                    </a>
                <?php elseif($contactInfo->type === 'phone'): ?>
                    <hr>
                    <a href="tel:<?php echo e($contactInfo->value); ?>" class="btn btn-sm btn-outline-success w-100">
                        <i class="fas fa-phone"></i> Call Number
                    </a>
                <?php elseif($contactInfo->type === 'social' && filter_var($contactInfo->value, FILTER_VALIDATE_URL)): ?>
                    <hr>
                    <a href="<?php echo e($contactInfo->value); ?>" target="_blank" class="btn btn-sm btn-outline-info w-100">
                        <i class="fas fa-external-link-alt"></i> Visit Profile
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Icon Selection</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-map-marker')">
                            <i class="fa fa-map-marker"></i>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-phone')">
                            <i class="fa fa-phone"></i>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fa-envelope')">
                            <i class="fa fa-envelope"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function updatePreview() {
    const type = document.getElementById('type').value || 'other';
    const label = document.getElementById('label').value || 'Contact Label';
    const value = document.getElementById('value').value || 'Contact Value';
    const icon = document.getElementById('icon').value || getDefaultIcon(type);
    
    document.getElementById('preview-label').innerHTML = `<strong>${label}</strong>`;
    document.getElementById('preview-value').textContent = value;
    document.getElementById('preview-icon').className = `fa ${icon} fa-2x text-primary mb-2`;
}

function setIcon(iconClass) {
    document.getElementById('icon').value = iconClass;
    updatePreview();
}

function getDefaultIcon(type) {
    const icons = {
        'address': 'fa-map-marker',
        'phone': 'fa-phone',
        'email': 'fa-envelope',
        'website': 'fa-globe',
        'social': 'fa-share-alt',
        'other': 'fa-info-circle'
    };
    return icons[type] || 'fa-info-circle';
}

// Update icon suggestion when type changes
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const iconField = document.getElementById('icon');
    
    if (!iconField.value) {
        iconField.value = getDefaultIcon(type);
    }
    
    updatePreview();
});

// Update preview when inputs change
document.getElementById('label').addEventListener('input', updatePreview);
document.getElementById('value').addEventListener('input', updatePreview);
document.getElementById('icon').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/contact-info/edit.blade.php ENDPATH**/ ?>