@extends('layouts.admin')

@section('title', 'Create Site Setting')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create Site Setting</h1>
    <a href="{{ route('admin.site-settings.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.site-settings.store') }}" method="POST">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="key" class="form-label">Key <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('key') is-invalid @enderror" 
                               id="key" name="key" value="{{ old('key') }}" required>
                        @error('key')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Unique identifier for this setting (e.g., site_title, hero_background)</div>
                    </div>

                    <div class="mb-3">
                        <label for="group" class="form-label">Group <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('group') is-invalid @enderror" 
                               id="group" name="group" value="{{ old('group') }}" required>
                        @error('group')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Group this setting belongs to (e.g., general, hero, about, portfolio, contact)</div>
                    </div>

                    <div class="mb-3">
                        <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Select Type</option>
                            <option value="text" {{ old('type') === 'text' ? 'selected' : '' }}>Text</option>
                            <option value="textarea" {{ old('type') === 'textarea' ? 'selected' : '' }}>Textarea</option>
                            <option value="image" {{ old('type') === 'image' ? 'selected' : '' }}>Image URL</option>
                            <option value="boolean" {{ old('type') === 'boolean' ? 'selected' : '' }}>Boolean</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="value" class="form-label">Value</label>
                        <div id="value-container">
                            <input type="text" class="form-control @error('value') is-invalid @enderror" 
                                   id="value" name="value" value="{{ old('value') }}">
                        </div>
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Order in which this setting should appear</div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Create Setting
                        </button>
                        <a href="{{ route('admin.site-settings.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Common Settings</h5>
            </div>
            <div class="card-body">
                <p class="text-muted small">Here are some common setting keys you might want to create:</p>
                <ul class="list-unstyled small">
                    <li><code>site_title</code> - Website title</li>
                    <li><code>site_logo</code> - Logo text</li>
                    <li><code>hero_background</code> - Hero section background image</li>
                    <li><code>about_title</code> - About section title</li>
                    <li><code>portfolio_title</code> - Portfolio section title</li>
                    <li><code>contact_title</code> - Contact section title</li>
                    <li><code>footer_text</code> - Footer text</li>
                </ul>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const valueContainer = document.getElementById('value-container');
    const currentValue = '{{ old("value") }}';
    
    let html = '';
    
    if (type === 'textarea') {
        html = `<textarea class="form-control" id="value" name="value" rows="4">${currentValue}</textarea>`;
    } else if (type === 'boolean') {
        html = `<select class="form-select" id="value" name="value">
                    <option value="0" ${currentValue === '0' ? 'selected' : ''}>False</option>
                    <option value="1" ${currentValue === '1' ? 'selected' : ''}>True</option>
                </select>`;
    } else {
        html = `<input type="text" class="form-control" id="value" name="value" value="${currentValue}">`;
    }
    
    valueContainer.innerHTML = html;
});
</script>
@endsection
