@extends('layouts.admin')

@section('title', 'View Portfolio Item')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Portfolio Item Details</h1>
    <div class="btn-group" role="group">
        <a href="{{ route('admin.portfolio-items.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Portfolio
        </a>
        <a href="{{ route('admin.portfolio-items.edit', $portfolioItem) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        @if($portfolioItem->image)
                            @if(filter_var($portfolioItem->image, FILTER_VALIDATE_URL))
                                <img src="{{ $portfolioItem->image }}" alt="{{ $portfolioItem->title }}" class="img-fluid rounded mb-3">
                            @else
                                <img src="{{ asset('storage/' . $portfolioItem->image) }}" alt="{{ $portfolioItem->title }}" class="img-fluid rounded mb-3">
                            @endif
                        @else
                            <div class="bg-light d-flex align-items-center justify-content-center rounded mb-3" style="height: 300px;">
                                <i class="fas fa-image fa-5x text-muted"></i>
                            </div>
                        @endif
                    </div>
                    <div class="col-md-6">
                        <h2>{{ $portfolioItem->title }}</h2>
                        
                        @if($portfolioItem->category)
                            <p><span class="badge bg-secondary fs-6">{{ $portfolioItem->category }}</span></p>
                        @endif

                        @if($portfolioItem->description)
                            <div class="mb-3">
                                <h5>Description</h5>
                                <p class="text-muted">{{ $portfolioItem->description }}</p>
                            </div>
                        @endif

                        <div class="mb-3">
                            <h5>Status</h5>
                            @if($portfolioItem->is_active)
                                <span class="badge bg-success fs-6">Active - Visible on website</span>
                            @else
                                <span class="badge bg-danger fs-6">Inactive - Hidden from website</span>
                            @endif
                        </div>

                        @if($portfolioItem->url)
                            <div class="mb-3">
                                <h5>External Link</h5>
                                <a href="{{ $portfolioItem->url }}" target="_blank" class="btn btn-outline-primary">
                                    <i class="fas fa-external-link-alt"></i> View Project
                                </a>
                            </div>
                        @endif

                        <div class="mb-3">
                            <h5>Display Order</h5>
                            <p class="text-muted">Sort Order: {{ $portfolioItem->sort_order ?? 0 }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Item Information</h5>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8">{{ $portfolioItem->id }}</dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8">{{ $portfolioItem->created_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $portfolioItem->created_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Updated:</dt>
                    <dd class="col-sm-8">{{ $portfolioItem->updated_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $portfolioItem->updated_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Category:</dt>
                    <dd class="col-sm-8">{{ $portfolioItem->category ?? 'Uncategorized' }}</dd>
                    
                    <dt class="col-sm-4">Sort Order:</dt>
                    <dd class="col-sm-8">{{ $portfolioItem->sort_order ?? 0 }}</dd>
                </dl>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.portfolio-items.edit', $portfolioItem) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Item
                    </a>
                    
                    @if($portfolioItem->url)
                        <a href="{{ $portfolioItem->url }}" target="_blank" class="btn btn-info">
                            <i class="fas fa-external-link-alt"></i> View External Link
                        </a>
                    @endif
                    
                    <a href="{{ route('home') }}#portfolio" target="_blank" class="btn btn-success">
                        <i class="fas fa-eye"></i> View on Website
                    </a>
                    
                    <hr>
                    
                    <form action="{{ route('admin.portfolio-items.destroy', $portfolioItem) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this portfolio item? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Item
                        </button>
                    </form>
                </div>
            </div>
        </div>

        @if($portfolioItem->image)
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Image Details</h5>
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">Image URL:</p>
                <p class="small"><code>{{ $portfolioItem->image }}</code></p>
                
                <button class="btn btn-sm btn-outline-secondary" onclick="copyToClipboard('{{ $portfolioItem->image }}')">
                    <i class="fas fa-copy"></i> Copy URL
                </button>
            </div>
        </div>
        @endif
    </div>
</div>
@endsection

@section('scripts')
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Image URL copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>
@endsection
