@extends('layouts.admin')

@section('title', 'Portfolio Items')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Portfolio Items</h1>
    <a href="{{ route('admin.portfolio-items.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Portfolio Item
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($portfolioItems->count() > 0)
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($portfolioItems as $item)
                            <tr>
                                <td>
                                    @if($item->image)
                                        @if(filter_var($item->image, FILTER_VALIDATE_URL))
                                            <img src="{{ $item->image }}" alt="{{ $item->title }}" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        @else
                                            <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->title }}" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        @endif
                                    @else
                                        <div class="bg-light d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                            <i class="fas fa-image text-muted"></i>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    <strong>{{ $item->title }}</strong>
                                    @if($item->description)
                                        <br><small class="text-muted">{{ Str::limit($item->description, 50) }}</small>
                                    @endif
                                </td>
                                <td>
                                    @if($item->category)
                                        <span class="badge bg-secondary">{{ $item->category }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($item->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $item->sort_order ?? 0 }}</td>
                                <td>
                                    <small class="text-muted">
                                        {{ $item->created_at->format('M j, Y') }}
                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.portfolio-items.show', $item) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.portfolio-items.edit', $item) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.portfolio-items.destroy', $item) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this portfolio item?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-th fa-3x mb-3"></i>
                <p class="h5">No portfolio items found</p>
                <p>Start by creating your first portfolio item to showcase your work.</p>
                <a href="{{ route('admin.portfolio-items.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First Portfolio Item
                </a>
            </div>
        @endif
    </div>
</div>

@if($portfolioItems->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Portfolio Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">{{ $portfolioItems->count() }}</h4>
                            <small class="text-muted">Total Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">{{ $portfolioItems->where('is_active', true)->count() }}</h4>
                            <small class="text-muted">Active Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">{{ $portfolioItems->whereNotNull('category')->pluck('category')->unique()->count() }}</h4>
                            <small class="text-muted">Categories</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">{{ $portfolioItems->whereNotNull('url')->count() }}</h4>
                            <small class="text-muted">With Links</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endsection
