<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title', $siteSettings['site_title'] ?? 'My Portfolio'); ?></title>
    <meta name="description" content="<?php echo $__env->yieldContent('description', $siteSettings['site_description'] ?? 'Professional portfolio showcasing creative work and services'); ?>">
    <meta name="keywords" content="<?php echo $__env->yieldContent('keywords', $siteSettings['site_keywords'] ?? 'portfolio, creative, design, professional'); ?>">
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Lato">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <style>
        body,h1,h2,h3,h4,h5,h6 {font-family: "Lato", sans-serif;}
        body, html {
            height: 100%;
            color: #777;
            line-height: 1.8;
            padding-top: 0;
            margin-top: 0;
        }
        
        /* Ensure content doesn't go under fixed navigation */
        body {
            padding-top: 0 !important;
        }
        
        /* Emergency fallback for banner titles */
        h1.banner-title {
            color: white !important;
            font-size: 3rem !important;
            font-weight: bold !important;
            text-transform: uppercase !important;
            margin: 20px 0 !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
        }

        /* Create a Parallax Effect */
        .bgimg-1, .bgimg-2, .bgimg-3 {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            position: relative;
            margin-top: 0 !important;
            padding-top: 0 !important;
        }

        /* First image (Logo. Full height) */
        .bgimg-1 {
            background-image: url('<?php echo e(isset($banners["hero"]) ? $banners["hero"]->background_image : ($siteSettings["hero_background"] ?? "https://www.w3schools.com/w3images/parallax1.jpg")); ?>');
            min-height: 100vh;
        }

        /* Second image (Portfolio) */
        .bgimg-2 {
            background-image: url('<?php echo e(isset($banners["portfolio"]) ? $banners["portfolio"]->background_image : ($siteSettings["portfolio_background"] ?? "https://www.w3schools.com/w3images/parallax2.jpg")); ?>');
            min-height: 100vh;
        }

        /* Third image (Contact) */
        .bgimg-3 {
            background-image: url('<?php echo e(isset($banners["contact"]) ? $banners["contact"]->background_image : ($siteSettings["contact_background"] ?? "https://www.w3schools.com/w3images/parallax3.jpg")); ?>');
            min-height: 100vh;
        }

        /* ========== UNIFIED BANNER SYSTEM ========== */
        
        /* Banner Container */
        .modern-banner,
        .bgimg-1.modern-banner,
        .bgimg-2.modern-banner,
        .bgimg-3.modern-banner {
            position: relative;
            overflow: hidden;
            z-index: 1;
            min-height: 100vh;
        }
        
        .modern-banner.w3-display-container {
            position: relative !important;
        }
        
        .modern-banner::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.6), rgba(0, 86, 179, 0.4));
            z-index: 1;
        }
        
        .modern-banner::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at center, transparent 0%, rgba(0, 0, 0, 0.4) 100%);
            z-index: 2;
        }
        
        /* Banner Content Container */
        .banner-content,
        .modern-banner .banner-content,
        .w3-display-middle.banner-content {
            position: relative !important;
            z-index: 3 !important;
            text-align: center !important;
            color: white !important;
            max-width: 1000px !important;
            padding: 60px 40px !important;
            margin: 0 auto !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            width: 90% !important;
            box-sizing: border-box !important;
        }
        
        /* Perfect centering for W3.CSS display-middle */
        .w3-display-middle.banner-content {
            position: absolute !important;
            top: 50% !important;
            left: 50% !important;
            transform: translate(-50%, -50%) !important;
            margin: 0 !important;
        }
        
        /* Banner Titles - Unified for All Pages */
        .banner-title,
        .modern-banner .banner-title,
        .banner-content .banner-title,
        .banner-content h1,
        .bgimg-1 .banner-title,
        .bgimg-2 .banner-title,
        .bgimg-3 .banner-title {
            font-family: "Lato", sans-serif !important;
            font-size: clamp(3rem, 6vw, 5rem) !important;
            font-weight: 900 !important;
            margin: 0 0 30px 0 !important;
            color: #ffffff !important;
            text-shadow: 0 4px 20px rgba(0, 0, 0, 0.7) !important;
            animation: fadeInUp 1s ease-out;
            letter-spacing: 0px !important;
            text-transform: uppercase !important;
            line-height: 1.1 !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
        }
        
        /* Banner Subtitles - Unified for All Pages */
        .banner-subtitle,
        .modern-banner .banner-subtitle,
        .banner-content .banner-subtitle,
        .banner-content p.banner-subtitle {
            font-family: "Lato", sans-serif !important;
            font-size: clamp(1.2rem, 3vw, 1.6rem) !important;
            font-weight: 400 !important;
            margin: 0 auto 25px auto !important;
            color: #ffffff !important;
            opacity: 0.95 !important;
            line-height: 1.5 !important;
            animation: fadeInUp 1s ease-out 0.2s both;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.4) !important;
            display: block !important;
            visibility: visible !important;
            max-width: 700px !important;
            text-align: center !important;
            letter-spacing: 0px !important;
        }
        
        /* Banner Descriptions - Unified for All Pages */
        .banner-description,
        .modern-banner .banner-description,
        .banner-content .banner-description,
        .banner-content p.banner-description,
        .modern-banner p,
        .banner-content p {
            font-family: "Lato", sans-serif !important;
            font-size: clamp(1.1rem, 2.5vw, 1.4rem) !important;
            font-weight: 400 !important;
            margin: 20px auto 35px auto !important;
            color: #ffffff !important;
            opacity: 0.9 !important;
            line-height: 1.5 !important;
            animation: fadeInUp 1s ease-out 0.4s both;
            max-width: 650px !important;
            text-shadow: 0 2px 8px rgba(0, 0, 0, 0.4) !important;
            display: block !important;
            visibility: visible !important;
            text-align: center !important;
            padding: 0 10px !important;
            letter-spacing: 0px !important;
        }
        
        /* W3.CSS Override Protection */
        .modern-banner h1,
        .modern-banner h2,
        .modern-banner h3,
        .modern-banner h4,
        .modern-banner h5,
        .modern-banner h6,
        .w3-display-container h1,
        .w3-display-container h2,
        .w3-display-container h3,
        .w3-display-container h4,
        .w3-display-container h5,
        .w3-display-container h6 {
            font-family: "Lato", sans-serif !important;
            color: #ffffff !important;
            display: block !important;
            visibility: visible !important;
            opacity: 1 !important;
            letter-spacing: 0px !important;
        }
        
        /* Banner Buttons - Unified for All Pages */
        .banner-buttons {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
            animation: fadeInUp 1s ease-out 0.6s both;
            margin-top: 40px !important;
            padding-top: 20px !important;
        }
        
        .banner-btn {
            font-family: "Lato", sans-serif;
            padding: 15px 35px;
            border: none;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .banner-btn.primary {
            background: linear-gradient(135deg, #ffffff, #f8f9fa);
            color: #212529;
            box-shadow: 0 8px 30px rgba(255, 255, 255, 0.3);
        }
        
        .banner-btn.primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(255, 255, 255, 0.4);
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
        }
        
        .banner-btn.secondary {
            background: transparent;
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.4);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .banner-btn.secondary:hover {
            background: rgba(255, 255, 255, 0.1);
            border-color: rgba(255, 255, 255, 0.7);
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(255, 255, 255, 0.2);
        }
        
        .banner-floating-elements {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 2;
            pointer-events: none;
        }
        
        .floating-shape {
            position: absolute;
            background: rgba(255, 255, 255, 0.08);
            border-radius: 50%;
            animation: float 8s ease-in-out infinite;
        }
        
        .floating-shape:nth-child(1) {
            width: 80px;
            height: 80px;
            top: 15%;
            left: 8%;
            animation-delay: 0s;
        }
        
        .floating-shape:nth-child(2) {
            width: 120px;
            height: 120px;
            top: 55%;
            right: 12%;
            animation-delay: 2s;
        }
        
        .floating-shape:nth-child(3) {
            width: 60px;
            height: 60px;
            bottom: 25%;
            left: 18%;
            animation-delay: 4s;
        }
        
        .floating-shape:nth-child(4) {
            width: 100px;
            height: 100px;
            top: 35%;
            right: 25%;
            animation-delay: 1s;
        }
        
        .floating-shape:nth-child(5) {
            width: 40px;
            height: 40px;
            top: 70%;
            left: 45%;
            animation-delay: 3s;
        }

        .w3-wide {letter-spacing: 10px;}
        
        /* Override W3.CSS letter spacing for banner elements */
        .modern-banner .w3-wide,
        .banner-content .w3-wide,
        .banner-title.w3-wide,
        .banner-subtitle.w3-wide,
        .banner-description.w3-wide {
            letter-spacing: 0px !important;
        }
        .w3-hover-opacity {cursor: pointer;}

        /* Modern Header Styling */
        .w3-top {
            z-index: 9999 !important;
            position: fixed !important;
        }
        
        .modern-header {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.3s ease;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.1);
            z-index: 9999;
            position: relative;
        }
        
        .modern-header.scrolled {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 4px 30px rgba(0, 0, 0, 0.15);
        }
        
        .modern-nav-item {
            position: relative;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            text-transform: uppercase;
            font-size: 14px;
        }
        
        .modern-nav-item:hover {
            color: #007bff !important;
            transform: translateY(-2px);
        }
        
        .modern-nav-item::after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -5px;
            left: 50%;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }
        
        .modern-nav-item:hover::after {
            width: 80%;
        }
        
        .logo-text {
            font-weight: 700;
            font-size: 20px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: 1px;
        }
        
        .mobile-menu-btn {
            background: linear-gradient(135deg, #007bff, #0056b3);
            border: none;
            border-radius: 8px;
            padding: 8px;
            color: white;
            transition: all 0.3s ease;
        }
        
        .mobile-menu-btn:hover {
            transform: scale(1.1);
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        }
        
        .mobile-menu {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);
            border-radius: 0 0 20px 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            z-index: 10000;
        }
        
        .mobile-menu .w3-bar-item {
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .mobile-menu .w3-bar-item:hover {
            background: rgba(0, 123, 255, 0.1);
            color: #007bff;
            padding-left: 24px;
        }

        /* Modern Footer Styling */
        .modern-footer {
            background: linear-gradient(135deg, #1a1a1a 0%, #2d2d2d 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
        }
        
        .footer-content {
            position: relative;
            z-index: 2;
        }
        
        .back-to-top {
            background: linear-gradient(135deg, #007bff, #0056b3);
            border: none;
            border-radius: 50px;
            padding: 12px 24px;
            color: white;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        }
        
        .back-to-top:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
            background: linear-gradient(135deg, #0056b3, #007bff);
        }
        
        .social-links {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin: 20px 0;
        }
        
        .social-link {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.1);
            color: #fff;
            text-decoration: none;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .social-link:hover {
            background: rgba(0, 123, 255, 0.8);
            transform: translateY(-5px) scale(1.1);
            box-shadow: 0 10px 25px rgba(0, 123, 255, 0.4);
            color: #fff;
        }
        
        .footer-text {
            color: rgba(255, 255, 255, 0.7);
            font-size: 14px;
            margin-top: 20px;
        }
        
        .footer-divider {
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            margin: 30px 0 20px 0;
        }

        /* Animations */
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideUp {
            from {
                opacity: 1;
                transform: translateY(0);
            }
            to {
                opacity: 0;
                transform: translateY(-20px);
            }
        }
        
        /* Scroll animations */
        .fade-in {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.6s ease;
        }
        
        .fade-in.visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Modern Contact Section Styling */
        .modern-contact-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            position: relative;
        }
        
        .modern-contact-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 123, 255, 0.3), transparent);
        }
        
        /* Section Header */
        .contact-header {
            margin-bottom: 60px;
        }
        
        .section-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007bff, #0056b3);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
        }
        
        .section-subtitle {
            font-size: 1.2rem;
            color: #6c757d;
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .title-divider {
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        /* Contact Cards Row */
        .contact-cards-row {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 30px;
            align-items: stretch;
        }
        
        /* Contact Cards */
        .modern-contact-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);
            border-radius: 20px;
            padding: 25px 20px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
            height: 260px;
            position: relative;
            overflow: hidden;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }
        
        .modern-contact-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .modern-contact-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0, 123, 255, 0.15);
        }
        
        .modern-contact-card:hover::before {
            transform: scaleX(1);
        }
        
        .contact-card-icon {
            width: 60px;
            height: 60px;
            min-width: 60px;
            min-height: 60px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
            transition: all 0.3s ease;
            flex-shrink: 0;
        }
        
        .contact-card-icon i {
            font-size: 24px;
            color: white;
        }
        
        .modern-contact-card:hover .contact-card-icon {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
        }
        
        .contact-card-title {
            font-size: 1.2rem;
            font-weight: 600;
            color: #212529;
            margin: 10px 0 10px 0;
            flex-shrink: 0;
        }
        
        .contact-card-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 10px 0;
        }
        
        .contact-info {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 8px 0;
        }
        
        .contact-card-content p {
            color: #6c757d;
            margin: 0;
            line-height: 1.6;
            text-align: center;
        }
        
        .contact-link {
            color: #007bff;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .contact-link:hover {
            color: #0056b3;
            text-decoration: underline;
        }
        
        /* Contact Form Section */
        .modern-contact-form-section {
            background: white;
            border-radius: 25px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.1);
            margin-top: 60px;
            overflow: hidden;
        }
        
        .contact-form-intro {
            padding-right: 30px;
        }
        
        .form-title {
            font-size: 2rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 20px;
        }
        
        .form-description {
            color: #6c757d;
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        
        .business-info, .response-time {
            display: flex;
            align-items: flex-start;
            margin-bottom: 25px;
            padding: 20px;
            background: rgba(0, 123, 255, 0.05);
            border-radius: 15px;
            border-left: 4px solid #007bff;
        }
        
        .info-icon {
            color: #007bff;
            font-size: 20px;
            margin-right: 15px;
            margin-top: 3px;
        }
        
        .info-content strong {
            color: #212529;
            font-weight: 600;
            display: block;
            margin-bottom: 5px;
        }
        
        .info-content p {
            color: #6c757d;
            margin: 0;
            line-height: 1.5;
        }
        
        /* Modern Form Styling */
        .modern-contact-form {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            padding: 40px;
            border-radius: 20px;
        }
        
        .form-group-row {
            display: flex;
            gap: 20px;
            margin-bottom: 25px;
        }
        
        .form-group {
            position: relative;
            flex: 1;
            margin-bottom: 25px;
        }
        
        .modern-input {
            width: 100%;
            padding: 15px 0;
            font-size: 16px;
            border: none;
            border-bottom: 2px solid #e9ecef;
            background: transparent;
            outline: none;
            transition: all 0.3s ease;
            color: #212529;
        }
        
        .modern-textarea {
            resize: vertical;
            min-height: 120px;
            padding-top: 20px;
        }
        
        .modern-label {
            position: absolute;
            top: 15px;
            left: 0;
            font-size: 16px;
            color: #6c757d;
            transition: all 0.3s ease;
            pointer-events: none;
            font-weight: 500;
        }
        
        .modern-input:focus,
        .modern-input:not(:placeholder-shown) {
            border-bottom-color: #007bff;
        }
        
        .modern-input:focus + .modern-label,
        .modern-input:not(:placeholder-shown) + .modern-label {
            top: -10px;
            font-size: 14px;
            color: #007bff;
            font-weight: 600;
        }
        
        .modern-input.error {
            border-bottom-color: #dc3545;
        }
        
        .modern-input.error + .modern-label {
            color: #dc3545;
        }
        
        .input-border {
            position: absolute;
            bottom: 0;
            left: 0;
            height: 2px;
            width: 0;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transition: width 0.3s ease;
        }
        
        .modern-input:focus ~ .input-border {
            width: 100%;
        }
        
        /* Submit Button */
        .modern-submit-btn {
            background: linear-gradient(135deg, #007bff, #0056b3);
            border: none;
            border-radius: 50px;
            padding: 15px 40px;
            color: white;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .modern-submit-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0, 123, 255, 0.4);
        }
        
        .btn-text {
            position: relative;
            z-index: 2;
        }
        
        .btn-icon {
            margin-left: 10px;
            transition: transform 0.3s ease;
        }
        
        .modern-submit-btn:hover .btn-icon {
            transform: translateX(5px);
        }
        
        .btn-ripple {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.3s ease, height 0.3s ease;
        }
        
        .modern-submit-btn:active .btn-ripple {
            width: 300px;
            height: 300px;
        }
        
        /* Alert Messages */
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-success {
            background: rgba(40, 167, 69, 0.1);
            color: #155724;
            border: 1px solid rgba(40, 167, 69, 0.3);
        }
        
        .alert-error {
            background: rgba(220, 53, 69, 0.1);
            color: #721c24;
            border: 1px solid rgba(220, 53, 69, 0.3);
        }
        
        .alert ul {
            margin: 0;
            padding-left: 20px;
        }
        
        /* Social Media Section */
        .social-connect-section {
            margin-top: 80px;
            padding-top: 60px;
            border-top: 1px solid rgba(0, 123, 255, 0.1);
        }
        
        .social-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 15px;
        }
        
        .social-subtitle {
            color: #6c757d;
            font-size: 1.1rem;
            margin-bottom: 30px;
        }
        
        .modern-social-links {
            display: flex;
            justify-content: center;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        .modern-social-btn {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 24px;
            background: rgba(255, 255, 255, 0.9);
            border: 2px solid rgba(0, 123, 255, 0.2);
            border-radius: 50px;
            color: #007bff;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .modern-social-btn:hover {
            background: #007bff;
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .modern-social-btn.website-btn {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            border-color: #28a745;
        }
        
        .modern-social-btn.website-btn:hover {
            background: linear-gradient(135deg, #20c997, #28a745);
            transform: translateY(-3px) scale(1.05);
        }

        /* Modern Statistics Section Styling */
        .modern-stats-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-stats-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            z-index: 1;
        }
        
        .modern-stats-section .w3-container {
            position: relative;
            z-index: 2;
        }
        
        /* Stats Header */
        .stats-header {
            margin-bottom: 60px;
        }
        
        .stats-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: white;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .stats-section-subtitle {
            font-size: 1.2rem;
            color: rgba(255, 255, 255, 0.9);
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .stats-title-divider {
            width: 80px;
            height: 4px;
            background: rgba(255, 255, 255, 0.8);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        /* Statistics Grid */
        .modern-stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }
        
        /* Stat Cards */
        .modern-stat-card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.2);
            transition: all 0.4s ease;
            position: relative;
            overflow: hidden;
        }
        
        .modern-stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.1), transparent);
            transition: left 0.6s ease;
        }
        
        .modern-stat-card:hover {
            transform: translateY(-15px) scale(1.02);
            background: rgba(255, 255, 255, 0.25);
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.2);
        }
        
        .modern-stat-card:hover::before {
            left: 100%;
        }
        
        .stat-card-inner {
            position: relative;
            z-index: 2;
        }
        
        /* Icon Styling */
        .stat-icon-wrapper {
            position: relative;
            width: 80px;
            height: 80px;
            min-width: 80px;
            min-height: 80px;
            margin: 0 auto 25px;
            flex-shrink: 0;
        }
        
        .stat-icon-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            transition: all 0.3s ease;
        }
        
        .stat-icon {
            position: relative;
            z-index: 2;
            font-size: 32px;
            color: white;
            line-height: 80px;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            display: block;
            width: 100%;
            text-align: center;
        }
        
        .stat-icon:before {
            display: inline-block;
            font-family: FontAwesome;
        }
        
        .modern-stat-card:hover .stat-icon-bg {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.1) rotate(10deg);
        }
        
        .modern-stat-card:hover .stat-icon {
            transform: scale(1.1);
        }
        
        /* Counter Styling */
        .stat-counter-wrapper {
            margin-bottom: 20px;
        }
        
        .stat-counter {
            font-size: 3rem;
            font-weight: 700;
            color: white;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
            display: inline-block;
            transition: all 0.3s ease;
        }
        
        .stat-suffix {
            font-size: 2rem;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.9);
            margin-left: 5px;
        }
        
        .modern-stat-card:hover .stat-counter {
            transform: scale(1.1);
            color: #fff;
        }
        
        /* Label Styling */
        .stat-label {
            font-size: 1.2rem;
            font-weight: 600;
            color: rgba(255, 255, 255, 0.95);
            margin-bottom: 20px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        /* Progress Bar */
        .stat-progress-bar {
            width: 100%;
            height: 4px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 2px;
            overflow: hidden;
            margin-top: 20px;
        }
        
        .stat-progress-fill {
            height: 100%;
            background: linear-gradient(90deg, rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.6));
            border-radius: 2px;
            width: 0%;
            transition: width 2s ease-in-out;
        }
        
        /* Additional Stats Info */
        .additional-stats-info {
            margin-top: 60px;
        }
        
        .additional-stats-badge {
            display: inline-flex;
            align-items: center;
            gap: 10px;
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            padding: 15px 30px;
            border-radius: 50px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            color: white;
            font-weight: 600;
            margin-bottom: 15px;
            transition: all 0.3s ease;
        }
        
        .additional-stats-badge:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: translateY(-3px);
        }
        
        .additional-stats-text {
            color: rgba(255, 255, 255, 0.8);
            font-size: 1rem;
            margin: 0;
        }
        
        /* Background Elements */
        .stats-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .stats-bg-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.05);
            animation: float 6s ease-in-out infinite;
        }
        
        .stats-bg-circle-1 {
            width: 200px;
            height: 200px;
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }
        
        .stats-bg-circle-2 {
            width: 150px;
            height: 150px;
            top: 60%;
            right: 15%;
            animation-delay: 2s;
        }
        
        .stats-bg-circle-3 {
            width: 100px;
            height: 100px;
            bottom: 20%;
            left: 20%;
            animation-delay: 4s;
        }
        
        @keyframes float {
            0%, 100% {
                transform: translateY(0px);
            }
            50% {
                transform: translateY(-20px);
            }
        }
        
        /* Counter Animation */
        @keyframes countUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .stat-counter.animate {
            animation: countUp 0.8s ease-out;
        }

        /* Modern Portfolio Section Styling */
        .modern-portfolio-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-portfolio-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 123, 255, 0.3), transparent);
        }
        
        /* Portfolio Header */
        .portfolio-header {
            margin-bottom: 60px;
        }
        
        .portfolio-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007bff, #0056b3);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
        }
        
        .portfolio-section-subtitle {
            font-size: 1.2rem;
            color: #6c757d;
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .portfolio-title-divider {
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        /* Portfolio Grid */
        .modern-portfolio-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
            margin-bottom: 60px;
        }
        
        /* Portfolio Cards */
        .modern-portfolio-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            transition: all 0.4s ease;
            position: relative;
        }
        
        .modern-portfolio-card:hover {
            transform: translateY(-15px);
            box-shadow: 0 25px 60px rgba(0, 123, 255, 0.15);
        }
        
        .portfolio-card-inner {
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        
        /* Image Section */
        .portfolio-image-wrapper {
            position: relative;
            height: 250px;
            overflow: hidden;
        }
        
        .portfolio-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: all 0.4s ease;
            cursor: pointer;
        }
        
        .modern-portfolio-card:hover .portfolio-image {
            transform: scale(1.1);
        }
        
        /* Overlay */
        .portfolio-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.9), rgba(0, 86, 179, 0.9));
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: all 0.3s ease;
        }
        
        .modern-portfolio-card:hover .portfolio-overlay {
            opacity: 1;
        }
        
        .portfolio-overlay-content {
            text-align: center;
            color: white;
            transform: translateY(20px);
            transition: transform 0.3s ease;
        }
        
        .modern-portfolio-card:hover .portfolio-overlay-content {
            transform: translateY(0);
        }
        
        .portfolio-overlay-title {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        
        .portfolio-overlay-category {
            font-size: 1rem;
            opacity: 0.9;
            margin-bottom: 20px;
        }
        
        .portfolio-overlay-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
        }
        
        .portfolio-btn {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.3);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            cursor: pointer;
            text-decoration: none;
        }
        
        .portfolio-btn:hover {
            background: white;
            color: #007bff;
            transform: scale(1.1);
        }
        
        /* Content Section */
        .portfolio-content {
            padding: 25px;
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        
        .portfolio-meta {
            margin-bottom: 15px;
        }
        
        .portfolio-category-tag {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            padding: 6px 15px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .portfolio-title {
            font-size: 1.4rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 12px;
            line-height: 1.3;
        }
        
        .portfolio-description {
            color: #6c757d;
            font-size: 0.95rem;
            line-height: 1.6;
            margin-bottom: 20px;
            flex: 1;
        }
        
        /* Action Buttons */
        .portfolio-actions {
            display: flex;
            gap: 10px;
            margin-top: auto;
        }
        
        .portfolio-action-btn {
            flex: 1;
            padding: 12px 20px;
            border-radius: 10px;
            border: none;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            text-decoration: none;
        }
        
        .portfolio-action-btn.primary {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
        }
        
        .portfolio-action-btn.primary:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .portfolio-action-btn.secondary {
            background: rgba(0, 123, 255, 0.1);
            color: #007bff;
            border: 1px solid rgba(0, 123, 255, 0.2);
        }
        
        .portfolio-action-btn.secondary:hover {
            background: #007bff;
            color: white;
            transform: translateY(-2px);
        }
        
        /* View All Button */
        .portfolio-view-all {
            margin-top: 60px;
        }
        
        .modern-view-all-btn {
            display: inline-flex;
            align-items: center;
            gap: 15px;
            padding: 18px 40px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .modern-view-all-btn:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0, 123, 255, 0.4);
        }
        
        .btn-count {
            background: rgba(255, 255, 255, 0.2);
            padding: 4px 12px;
            border-radius: 15px;
            font-size: 14px;
        }
        
        .btn-arrow {
            transition: transform 0.3s ease;
        }
        
        .modern-view-all-btn:hover .btn-arrow {
            transform: translateX(5px);
        }
        
        /* Background Elements */
        .portfolio-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .portfolio-bg-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(0, 123, 255, 0.03);
            animation: float 8s ease-in-out infinite;
        }
        
        .portfolio-bg-shape-1 {
            width: 300px;
            height: 300px;
            top: 20%;
            right: 10%;
            animation-delay: 0s;
        }
        
        .portfolio-bg-shape-2 {
            width: 200px;
            height: 200px;
            bottom: 20%;
            left: 15%;
            animation-delay: 4s;
        }

        /* Modern Filter Tabs */
        .modern-filter-section {
            margin-bottom: 50px;
        }
        
        .modern-filter-tabs {
            display: inline-flex;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50px;
            padding: 8px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            gap: 5px;
        }
        
        .modern-filter-tab {
            padding: 12px 24px;
            border-radius: 25px;
            text-decoration: none;
            color: #6c757d;
            font-weight: 500;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .modern-filter-tab:hover {
            color: #007bff;
            background: rgba(0, 123, 255, 0.1);
        }
        
        .modern-filter-tab.active {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        }
        
        .modern-filter-tab.active:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
        }

        /* Modern Pagination */
        .modern-pagination {
            margin-top: 60px;
        }
        
        .pagination-wrapper {
            display: inline-flex;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50px;
            padding: 8px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            gap: 5px;
            margin-bottom: 20px;
        }
        
        .pagination-btn {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            color: #6c757d;
            font-weight: 600;
            transition: all 0.3s ease;
            border: none;
            background: transparent;
            cursor: pointer;
        }
        
        .pagination-btn:hover {
            background: rgba(0, 123, 255, 0.1);
            color: #007bff;
            transform: scale(1.1);
        }
        
        .pagination-btn.active {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.3);
        }
        
        .pagination-btn.disabled {
            opacity: 0.4;
            cursor: not-allowed;
        }
        
        .pagination-btn.disabled:hover {
            background: transparent;
            transform: none;
        }
        
        .pagination-info {
            color: #6c757d;
            font-size: 0.95rem;
            margin: 0;
        }
        
        /* Empty State */
        .portfolio-empty-state {
            padding: 80px 40px;
        }
        
        .empty-state-icon {
            width: 120px;
            height: 120px;
            background: linear-gradient(135deg, #f8f9fa, #e9ecef);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            border: 3px solid rgba(0, 123, 255, 0.1);
        }
        
        .empty-state-icon i {
            font-size: 48px;
            color: #6c757d;
        }
        
        .empty-state-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 15px;
        }
        
        .empty-state-description {
            color: #6c757d;
            font-size: 1.1rem;
            margin-bottom: 30px;
            max-width: 400px;
            margin-left: auto;
            margin-right: auto;
        }
        
        /* Portfolio Navigation */
        .portfolio-navigation {
            margin-top: 60px;
            padding-top: 40px;
            border-top: 1px solid rgba(0, 123, 255, 0.1);
        }

        /* Portfolio Detail Page Styling */
        .modern-portfolio-detail-section {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            position: relative;
            overflow: hidden;
        }
        
        .portfolio-detail-layout {
            display: grid;
            grid-template-columns: 1.2fr 0.8fr;
            gap: 60px;
            align-items: start;
        }
        
        .portfolio-detail-image {
            position: relative;
        }
        
        .detail-image-wrapper {
            position: relative;
            border-radius: 20px;
            overflow: hidden;
            background: white;
            padding: 20px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.1);
        }
        
        .detail-image {
            width: 100%;
            height: auto;
            border-radius: 15px;
            transition: all 0.4s ease;
        }
        
        .detail-image-overlay {
            position: absolute;
            top: 20px;
            left: 20px;
            right: 20px;
            bottom: 20px;
            background: rgba(0, 123, 255, 0.9);
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: all 0.3s ease;
        }
        
        .detail-image-wrapper:hover .detail-image-overlay {
            opacity: 1;
        }
        
        .detail-zoom-btn {
            background: rgba(255, 255, 255, 0.2);
            border: 2px solid rgba(255, 255, 255, 0.3);
            color: white;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 20px;
        }
        
        .detail-zoom-btn:hover {
            background: rgba(255, 255, 255, 0.3);
            transform: scale(1.1);
        }
        
        .portfolio-detail-content {
            background: white;
            border-radius: 25px;
            padding: 40px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
        }
        
        .detail-category-badge {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-block;
            margin-bottom: 20px;
        }
        
        .detail-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 25px;
            line-height: 1.2;
        }
        
        .detail-description {
            color: #6c757d;
            font-size: 1.2rem;
            line-height: 1.7;
            margin-bottom: 40px;
        }
        
        .detail-actions {
            display: flex;
            gap: 15px;
            flex-wrap: wrap;
        }
        
        .detail-action-btn {
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 10px;
            border: none;
            cursor: pointer;
        }
        
        .detail-action-btn.primary {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .detail-action-btn.primary:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0, 123, 255, 0.4);
        }
        
        .detail-action-btn.secondary {
            background: rgba(0, 123, 255, 0.1);
            color: #007bff;
            border: 2px solid rgba(0, 123, 255, 0.2);
        }
        
        .detail-action-btn.secondary:hover {
            background: #007bff;
            color: white;
            transform: translateY(-3px);
        }
        
        .portfolio-detail-bg {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .detail-bg-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(0, 123, 255, 0.02);
            animation: float 8s ease-in-out infinite;
        }
        
        .detail-bg-shape-1 {
            width: 300px;
            height: 300px;
            top: 20%;
            right: 10%;
            animation-delay: 0s;
        }
        
        .detail-bg-shape-2 {
            width: 200px;
            height: 200px;
            bottom: 20%;
            left: 15%;
            animation-delay: 4s;
        }

        /* Contact Page Additional Sections */
        .modern-info-section {
            background: linear-gradient(135deg, #f8f9fa 0%, #ffffff 100%);
            position: relative;
        }
        
        .info-cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
        }
        
        .modern-info-card {
            background: white;
            border-radius: 20px;
            padding: 40px 30px;
            text-align: center;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .modern-info-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .modern-info-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 60px rgba(0, 123, 255, 0.15);
        }
        
        .modern-info-card:hover::before {
            transform: scaleX(1);
        }
        
        .info-card-icon {
            width: 70px;
            height: 70px;
            min-width: 70px;
            min-height: 70px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            transition: all 0.3s ease;
            flex-shrink: 0;
        }
        
        .info-card-icon i {
            font-size: 28px;
            color: white;
        }
        
        .modern-info-card:hover .info-card-icon {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.4);
        }
        
        .info-card-title {
            font-size: 1.3rem;
            font-weight: 600;
            color: #212529;
            margin-bottom: 15px;
        }
        
        .info-card-content p {
            color: #6c757d;
            margin: 0;
            line-height: 1.6;
        }
        
        /* Social Media Section */
        .modern-social-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-social-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            z-index: 1;
        }
        
        .modern-social-section .w3-container {
            position: relative;
            z-index: 2;
        }
        
        .social-header {
            margin-bottom: 60px;
        }
        
        .social-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: white;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .social-section-subtitle {
            font-size: 1.2rem;
            color: rgba(255, 255, 255, 0.9);
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .social-title-divider {
            width: 80px;
            height: 4px;
            background: rgba(255, 255, 255, 0.8);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        .social-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .social-bg-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.05);
            animation: float 6s ease-in-out infinite;
        }
        
        .social-bg-circle-1 {
            width: 200px;
            height: 200px;
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }
        
        .social-bg-circle-2 {
            width: 150px;
            height: 150px;
            top: 60%;
            right: 15%;
            animation-delay: 3s;
        }
        
        /* Contact Action Buttons */
        .contact-card-action {
            margin-top: auto;
            padding-top: 10px;
            flex-shrink: 0;
        }
        
        .contact-action-btn {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            text-decoration: none;
            font-weight: 500;
            font-size: 13px;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 8px;
        }
        
        .contact-action-btn:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
            color: white;
        }

        /* Location Section */
        .modern-location-section {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            position: relative;
        }
        
        .location-header {
            margin-bottom: 60px;
        }
        
        .location-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007bff, #0056b3);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
        }
        
        .location-section-subtitle {
            font-size: 1.2rem;
            color: #6c757d;
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .location-title-divider {
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        .location-layout {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 40px;
            align-items: stretch;
        }
        
        .modern-location-card, .modern-map-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            height: 450px;
            display: flex;
            flex-direction: column;
        }
        
        .modern-location-card:hover, .modern-map-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 70px rgba(0, 123, 255, 0.12);
        }
        
        .location-card-header {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 25px;
            flex-shrink: 0;
        }
        
        .location-icon {
            width: 60px;
            height: 60px;
            min-width: 60px;
            min-height: 60px;
            background: linear-gradient(135deg, #007bff, #0056b3);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .location-icon i {
            font-size: 24px;
            color: white;
        }
        
        .location-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #212529;
            margin: 0;
        }
        
        .location-address {
            color: #6c757d;
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 25px;
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }
        
        .location-quick-contact {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-top: auto;
            flex-shrink: 0;
            border-top: 1px solid #e9ecef;
            padding-top: 25px;
        }
        
        .quick-contact-item {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px;
            background: rgba(0, 123, 255, 0.05);
            border-radius: 10px;
            border-left: 4px solid #007bff;
        }
        
        .quick-contact-item i {
            color: #007bff;
            font-size: 16px;
        }
        
        .quick-contact-item a {
            color: #007bff;
            text-decoration: none;
            font-weight: 500;
        }
        
        .quick-contact-item a:hover {
            color: #0056b3;
            text-decoration: underline;
        }
        
        /* Map Card */
        .map-placeholder {
            text-align: center;
            padding: 40px 20px;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }
        
        .map-icon {
            width: 80px;
            height: 80px;
            min-width: 80px;
            min-height: 80px;
            background: linear-gradient(135deg, #28a745, #20c997);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            flex-shrink: 0;
        }
        
        .map-icon i {
            font-size: 32px;
            color: white;
        }
        
        .map-title {
            font-size: 1.5rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 15px;
        }
        
        .map-description {
            color: #6c757d;
            margin-bottom: 25px;
        }
        
        .map-action-btn {
            background: linear-gradient(135deg, #28a745, #20c997);
            color: white;
            padding: 12px 25px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            margin-top: auto;
        }
        
        .map-action-btn:hover {
            background: linear-gradient(135deg, #20c997, #28a745);
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(40, 167, 69, 0.3);
            color: white;
        }
        
        /* Call to Action Section */
        .modern-cta-section {
            background: linear-gradient(135deg, #212529 0%, #343a40 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-cta-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.1);
            z-index: 1;
        }
        
        .modern-cta-section .w3-container {
            position: relative;
            z-index: 2;
        }
        
        .cta-content {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .cta-title {
            font-size: 2.5rem;
            font-weight: 700;
            color: white;
            margin-bottom: 20px;
            text-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .cta-subtitle {
            font-size: 1.2rem;
            color: rgba(255, 255, 255, 0.9);
            margin-bottom: 40px;
            line-height: 1.6;
        }
        
        .cta-actions {
            display: flex;
            gap: 20px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .cta-btn {
            padding: 18px 35px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 12px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .cta-btn.primary {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .cta-btn.primary:hover {
            background: linear-gradient(135deg, #0056b3, #007bff);
            transform: translateY(-3px);
            box-shadow: 0 12px 35px rgba(0, 123, 255, 0.4);
            color: white;
        }
        
        .cta-btn.secondary {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
        }
        
        .cta-btn.secondary:hover {
            background: white;
            color: #007bff;
            transform: translateY(-3px);
        }
        
        .cta-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .cta-bg-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.03);
            animation: float 8s ease-in-out infinite;
        }
        
        .cta-bg-shape-1 {
            width: 250px;
            height: 250px;
            top: 10%;
            right: 10%;
            animation-delay: 0s;
        }
        
        .cta-bg-shape-2 {
            width: 180px;
            height: 180px;
            bottom: 15%;
            left: 15%;
            animation-delay: 4s;
        }
        
        .location-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .location-bg-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(0, 123, 255, 0.02);
            animation: float 10s ease-in-out infinite;
        }
        
        .location-bg-shape-1 {
            width: 200px;
            height: 200px;
            top: 20%;
            right: 10%;
            animation-delay: 0s;
        }
        
        .location-bg-shape-2 {
            width: 150px;
            height: 150px;
            bottom: 20%;
            left: 20%;
            animation-delay: 5s;
        }

        /* Enhanced Modal Styling */
        .modern-modal {
            display: none;
            position: fixed;
            z-index: 9999;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            transition: opacity 0.3s ease;
        }
        
        .modern-modal-backdrop {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.9);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .modern-modal-content {
            position: relative;
            margin: auto;
            padding: 20px;
            width: 90%;
            max-width: 1200px;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .modern-modal-close {
            position: absolute;
            top: 20px;
            right: 20px;
            background: rgba(255, 255, 255, 0.1);
            border: 2px solid rgba(255, 255, 255, 0.3);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 10001;
        }
        
        .modern-modal-close:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: scale(1.1);
        }
        
        .modern-modal-inner {
            text-align: center;
            max-width: 100%;
            max-height: 90%;
        }
        
        .modern-modal-image {
            max-width: 100%;
            max-height: 80vh;
            object-fit: contain;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
        }
        
        .modern-modal-caption {
            color: white;
            font-size: 1.2rem;
            margin-top: 20px;
            padding: 15px 30px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 25px;
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
            display: inline-block;
        }

        /* Modern About Section Styling */
        .modern-about-section {
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            position: relative;
            overflow: hidden;
        }
        
        .modern-about-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 123, 255, 0.3), transparent);
        }
        
        /* About Header */
        .about-header {
            margin-bottom: 60px;
        }
        
        .about-section-title {
            font-size: 2.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #007bff, #0056b3);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 16px;
            letter-spacing: -0.5px;
        }
        
        .about-section-subtitle {
            font-size: 1.2rem;
            color: #6c757d;
            max-width: 600px;
            margin: 0 auto 30px;
            line-height: 1.6;
        }
        
        .about-title-divider {
            width: 80px;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            margin: 0 auto;
            border-radius: 2px;
        }
        
        /* About Content */
        .modern-about-content {
            margin-bottom: 80px;
        }
        
        .modern-about-card {
            margin-bottom: 60px;
        }
        
        .modern-about-card:last-child {
            margin-bottom: 0;
        }
        
        /* Card Layouts */
        .about-card-layout {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: center;
            background: white;
            border-radius: 25px;
            padding: 50px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
        }
        
        .about-card-layout::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .about-card-layout:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 70px rgba(0, 123, 255, 0.12);
        }
        
        .about-card-layout:hover::before {
            transform: scaleX(1);
        }
        
        .about-card-layout.image-right {
            grid-template-columns: 1fr 1fr;
        }
        
        .about-card-layout.image-right .about-image-wrapper {
            order: 2;
        }
        
        .about-card-layout.image-right .about-content-wrapper {
            order: 1;
        }
        
        /* Image Section */
        .about-image-wrapper {
            position: relative;
        }
        
        .about-image-container {
            position: relative;
            border-radius: 20px;
            overflow: hidden;
            background: linear-gradient(135deg, #007bff, #0056b3);
            padding: 4px;
        }
        
        .about-image {
            width: 100%;
            height: auto;
            border-radius: 16px;
            transition: all 0.4s ease;
            display: block;
        }
        
        .about-image-overlay {
            position: absolute;
            top: 4px;
            left: 4px;
            right: 4px;
            bottom: 4px;
            border-radius: 16px;
            background: linear-gradient(135deg, rgba(0, 123, 255, 0.1), rgba(0, 86, 179, 0.1));
            opacity: 0;
            transition: all 0.3s ease;
        }
        
        .about-image-container:hover .about-image-overlay {
            opacity: 1;
        }
        
        .about-image-decoration {
            position: absolute;
            top: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            transform: scale(0);
            transition: transform 0.3s ease;
        }
        
        .about-image-decoration::before {
            content: '✨';
            font-size: 24px;
        }
        
        .about-image-container:hover .about-image-decoration {
            transform: scale(1);
        }
        
        /* Content Section */
        .about-content-wrapper {
            position: relative;
        }
        
        .about-content-inner {
            position: relative;
        }
        
        .about-content-badge {
            display: inline-block;
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 18px;
            margin-bottom: 25px;
            box-shadow: 0 8px 25px rgba(0, 123, 255, 0.3);
        }
        
        .about-content-title {
            font-size: 2rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 15px;
            line-height: 1.3;
        }
        
        .about-content-subtitle {
            font-size: 1.2rem;
            color: #007bff;
            font-weight: 600;
            margin-bottom: 20px;
            font-style: italic;
        }
        
        .about-content-text {
            color: #6c757d;
            font-size: 1.1rem;
            line-height: 1.7;
        }
        
        .about-content-text p {
            margin-bottom: 15px;
        }
        
        /* Full Width Card */
        .about-full-width-card {
            background: white;
            border-radius: 25px;
            padding: 50px;
            text-align: center;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
        }
        
        .about-full-width-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #007bff, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .about-full-width-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 70px rgba(0, 123, 255, 0.12);
        }
        
        .about-full-width-card:hover::before {
            transform: scaleX(1);
        }
        
        /* Skills Section */
        .modern-skills-section {
            margin-top: 80px;
            padding-top: 60px;
            border-top: 1px solid rgba(0, 123, 255, 0.1);
        }
        
        .skills-layout {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            align-items: start;
        }
        
        /* Profile Card */
        .modern-profile-card {
            background: white;
            border-radius: 25px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            position: relative;
            overflow: hidden;
            transition: all 0.4s ease;
        }
        
        .modern-profile-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 70px rgba(0, 123, 255, 0.12);
        }
        
        .profile-image-wrapper {
            position: relative;
            width: 200px;
            height: 200px;
            margin: 0 auto 30px;
        }
        
        .profile-image {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            object-fit: cover;
            transition: all 0.4s ease;
        }
        
        .profile-image-border {
            position: absolute;
            top: -10px;
            left: -10px;
            right: -10px;
            bottom: -10px;
            border: 3px solid transparent;
            border-radius: 50%;
            background: linear-gradient(135deg, #007bff, #0056b3) border-box;
            -webkit-mask: linear-gradient(#fff 0 0) padding-box, linear-gradient(#fff 0 0);
            -webkit-mask-composite: destination-out;
            mask: linear-gradient(#fff 0 0) padding-box, linear-gradient(#fff 0 0);
            mask-composite: exclude;
            transition: all 0.3s ease;
        }
        
        .modern-profile-card:hover .profile-image {
            transform: scale(1.05);
        }
        
        .profile-name {
            font-size: 1.8rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 10px;
        }
        
        .profile-title {
            font-size: 1.2rem;
            color: #007bff;
            font-weight: 600;
            margin-bottom: 20px;
        }
        
        .profile-description {
            color: #6c757d;
            font-size: 1rem;
            line-height: 1.6;
        }
        
        /* Skills Card */
        .modern-skills-card {
            background: white;
            border-radius: 25px;
            padding: 40px;
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.08);
            transition: all 0.4s ease;
        }
        
        .modern-skills-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 25px 70px rgba(0, 123, 255, 0.12);
        }
        
        .skills-title {
            font-size: 1.8rem;
            font-weight: 700;
            color: #212529;
            margin-bottom: 10px;
        }
        
        .skills-subtitle {
            color: #6c757d;
            font-size: 1.1rem;
            margin-bottom: 30px;
        }
        
        .skills-grid {
            display: flex;
            flex-direction: column;
            gap: 25px;
        }
        
        /* Skill Items */
        .modern-skill-item {
            position: relative;
        }
        
        .skill-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 10px;
        }
        
        .skill-name {
            font-weight: 600;
            color: #212529;
            font-size: 1rem;
        }
        
        .skill-percentage {
            font-weight: 700;
            color: #007bff;
            font-size: 1rem;
        }
        
        .skill-progress-wrapper {
            position: relative;
            height: 8px;
            background: #f1f3f4;
            border-radius: 10px;
            overflow: hidden;
        }
        
        .skill-progress-track {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: #f1f3f4;
            border-radius: 10px;
        }
        
        .skill-progress-bar {
            height: 100%;
            border-radius: 10px;
            width: 0%;
            transition: width 1.5s ease-in-out;
            position: relative;
        }
        
        .skill-progress-bar::after {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 20px;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.5));
            border-radius: 10px;
            animation: shimmer 2s infinite;
        }
        
        @keyframes shimmer {
            0% { transform: translateX(-20px); opacity: 0; }
            50% { opacity: 1; }
            100% { transform: translateX(20px); opacity: 0; }
        }
        
        /* Background Elements */
        .about-bg-elements {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: 0;
        }
        
        .about-bg-shape {
            position: absolute;
            border-radius: 50%;
            background: rgba(0, 123, 255, 0.02);
            animation: float 10s ease-in-out infinite;
        }
        
        .about-bg-shape-1 {
            width: 400px;
            height: 400px;
            top: 10%;
            right: 5%;
            animation-delay: 0s;
        }
        
        .about-bg-shape-2 {
            width: 250px;
            height: 250px;
            bottom: 15%;
            left: 10%;
            animation-delay: 5s;
        }
        
        .about-bg-pattern {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, rgba(0, 123, 255, 0.05) 1px, transparent 1px);
            background-size: 20px 20px;
            transform: translate(-50%, -50%);
            opacity: 0.3;
            animation: rotate 30s linear infinite;
        }
        
        @keyframes rotate {
            from { transform: translate(-50%, -50%) rotate(0deg); }
            to { transform: translate(-50%, -50%) rotate(360deg); }
        }

        /* Turn off parallax scrolling for tablets and phones */
        @media only screen and (max-device-width: 1600px) {
            .bgimg-1, .bgimg-2, .bgimg-3 {
                background-attachment: scroll;
                min-height: 400px;
            }
        }

        /* Responsive Design Enhancements */
        
        /* About Section Responsive */
        @media (max-width: 768px) {
            .about-card-layout {
                grid-template-columns: 1fr;
                gap: 30px;
                padding: 30px;
            }
            
            .about-card-layout.image-right .about-image-wrapper,
            .about-card-layout.image-right .about-content-wrapper {
                order: unset;
            }
            
            .skills-layout {
                grid-template-columns: 1fr;
                gap: 40px;
            }
            
            .about-section-title {
                font-size: 2rem;
            }
            
            .about-content-title {
                font-size: 1.6rem;
            }
            
            .profile-image-wrapper {
                width: 150px;
                height: 150px;
            }
        }
        
        @media (max-width: 480px) {
            .about-card-layout {
                padding: 25px;
                gap: 20px;
            }
            
            .about-full-width-card {
                padding: 30px 20px;
            }
            
            .about-section-title {
                font-size: 1.8rem;
            }
            
            .about-content-title {
                font-size: 1.4rem;
            }
            
            .profile-image-wrapper {
                width: 120px;
                height: 120px;
            }
        }

        /* Portfolio Section Responsive */
        @media (max-width: 768px) {
            .modern-portfolio-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .portfolio-section-title {
                font-size: 2rem;
            }
            
            .portfolio-actions {
                flex-direction: column;
                gap: 8px;
            }
            
            .portfolio-action-btn {
                justify-content: center;
            }
            
            .modern-view-all-btn {
                padding: 15px 30px;
                font-size: 14px;
            }
        }
        
        @media (max-width: 480px) {
            .modern-portfolio-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .portfolio-section-title {
                font-size: 1.8rem;
            }
            
            .portfolio-content {
                padding: 20px;
            }
            
            .portfolio-image-wrapper {
                height: 200px;
            }
        }

        /* Statistics Section Responsive */
        @media (max-width: 768px) {
            .modern-stats-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .stats-section-title {
                font-size: 2rem;
            }
            
            .stat-counter {
                font-size: 2.5rem;
            }
            
            .stat-suffix {
                font-size: 1.5rem;
            }
            
            .modern-stat-card {
                padding: 30px 20px;
            }
        }
        
        @media (max-width: 480px) {
            .modern-stats-grid {
                gap: 15px;
            }
            
            .stats-section-title {
                font-size: 1.8rem;
            }
            
            .stat-counter {
                font-size: 2rem;
            }
            
            .stat-suffix {
                font-size: 1.2rem;
            }
        }

        /* Contact Section Responsive */
        /* Medium screens - 2 columns for contact cards */
        @media (max-width: 1200px) {
            .contact-cards-row {
                grid-template-columns: repeat(2, 1fr);
                gap: 25px;
            }
        }
        
        @media (max-width: 768px) {
            .form-group-row {
                flex-direction: column;
                gap: 0;
            }
            
            .contact-form-intro {
                padding-right: 0;
                margin-bottom: 30px;
            }
            
            .modern-contact-form {
                padding: 30px 20px;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .modern-social-links {
                flex-direction: column;
                align-items: center;
            }
            
            .modern-social-btn {
                width: 200px;
                justify-content: center;
            }
            
            .location-layout {
                grid-template-columns: 1fr;
                gap: 30px;
            }
            
            .modern-location-card, .modern-map-card {
                height: 380px;
            }
            
            .cta-actions {
                flex-direction: column;
                align-items: center;
            }
            
            .cta-btn {
                width: 250px;
                justify-content: center;
            }
            
            .info-cards-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .contact-cards-row {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .modern-contact-card {
                height: 240px;
            }
        }
        
        @media (max-width: 480px) {
            .contact-cards-row {
                gap: 15px;
            }
            
            .modern-contact-card {
                height: 220px;
                padding: 20px 15px;
            }
            
            .contact-card-icon {
                width: 50px;
                height: 50px;
                min-width: 50px;
                min-height: 50px;
            }
            
            .contact-card-icon i {
                font-size: 20px;
            }
            
            .modern-location-card, .modern-map-card {
                height: 320px;
                padding: 30px 20px;
            }
            
            .location-icon {
                width: 50px;
                height: 50px;
                min-width: 50px;
                min-height: 50px;
            }
            
            .location-icon i {
                font-size: 20px;
            }
            
            .map-icon {
                width: 60px;
                height: 60px;
                min-width: 60px;
                min-height: 60px;
            }
            
            .map-icon i {
                font-size: 24px;
            }
        }

        /* Mobile First - Extra Small devices (phones, 600px and down) */
        @media only screen and (max-width: 600px) {
            .bgimg-1, .bgimg-2, .bgimg-3 {
                min-height: 80vh;
                background-attachment: scroll;
            }
            
            .modern-banner {
                min-height: 80vh;
            }
            
            .banner-content {
                padding: 60px 25px !important;
                margin: 0 auto !important;
                width: 95% !important;
            }
            
            .w3-display-middle.banner-content {
                margin: 0 !important;
                padding: 50px 20px !important;
            }
            
            .w3-wide {
                letter-spacing: 2px;
            }
            
            .w3-xxlarge {
                font-size: 28px !important;
            }
            
            .w3-xlarge {
                font-size: 20px !important;
            }
            
            .w3-large {
                font-size: 16px !important;
            }
            
            /* Mobile padding adjustments */
            .w3-padding-64 {
                padding: 32px 16px !important;
            }
            
            .w3-padding-32 {
                padding: 16px 8px !important;
            }
            
            /* Mobile content width */
            .w3-content {
                max-width: 100% !important;
                margin: 0 !important;
                padding: 0 16px !important;
            }
            
            /* Mobile card adjustments */
            .w3-card {
                margin-bottom: 16px !important;
            }
            
            /* Mobile button adjustments */
            .w3-button {
                padding: 8px 16px !important;
                font-size: 14px !important;
            }
            
            /* Mobile form adjustments */
            .w3-input {
                font-size: 16px !important; /* Prevent zoom on iOS */
            }
            
            /* Mobile navigation adjustments */
            .w3-bar-item {
                padding: 12px 16px !important;
            }
            
            /* Mobile image adjustments */
            img {
                max-width: 100% !important;
                height: auto !important;
            }
            
            /* Mobile progress bar */
            .w3-progress-container {
                margin-bottom: 16px !important;
            }
        }
        
        /* Small devices (portrait tablets and large phones, 600px to 768px) */
        @media only screen and (min-width: 600px) and (max-width: 768px) {
            .bgimg-1, .bgimg-2, .bgimg-3 {
                min-height: 90vh;
            }
            
            .modern-banner {
                min-height: 90vh;
            }
            
            .banner-content {
                padding: 70px 30px !important;
                margin: 0 auto !important;
                width: 92% !important;
            }
            
            .w3-display-middle.banner-content {
                margin: 0 !important;
                padding: 60px 25px !important;
            }
            
            .w3-content {
                max-width: 90% !important;
            }
            
            .w3-padding-64 {
                padding: 48px 24px !important;
            }
            
            .w3-xxlarge {
                font-size: 32px !important;
            }
            
            /* Tablet card spacing */
            .w3-margin-bottom {
                margin-bottom: 24px !important;
            }
        }
        
        /* Medium devices (landscape tablets, 768px to 992px) */
        @media only screen and (min-width: 768px) and (max-width: 992px) {
            .w3-content {
                max-width: 85% !important;
            }
            
            .bgimg-1 {
                min-height: 500px;
            }
            
            .bgimg-2, .bgimg-3 {
                min-height: 400px;
            }
        }
        
        /* Large devices (laptops/desktops, 992px and up) */
        @media only screen and (min-width: 992px) {
            .w3-content {
                max-width: 1200px !important;
            }
        }
        
        /* Extra responsive utilities */
        .w3-mobile {
            display: block !important;
            width: 100% !important;
        }
        
        @media (max-width: 600px) {
            .w3-hide-mobile {
                display: none !important;
            }
            
            .w3-mobile {
                display: block !important;
                width: 100% !important;
            }
            
            /* Mobile-specific flex adjustments */
            .w3-row-padding > .w3-col {
                padding: 0 8px !important;
            }
            
            /* Mobile footer adjustments */
            footer .w3-xlarge .w3-margin-right {
                margin-right: 8px !important;
                margin-bottom: 8px !important;
                display: inline-block;
            }
        }
        
        /* Touch device optimizations */
        @media (hover: none) and (pointer: coarse) {
            .w3-hover-opacity:hover {
                opacity: 0.8;
            }
            
            .w3-button:hover {
                background-color: #ccc !important;
            }
            
            /* Larger touch targets */
            .w3-button, .w3-bar-item {
                min-height: 44px;
                display: flex;
                align-items: center;
                justify-content: center;
            }
        }
        
        /* Additional mobile navigation improvements */
        @media (max-width: 600px) {
            #navDemo {
                width: 100%;
                z-index: 999;
                box-shadow: 0 2px 5px rgba(0,0,0,0.16);
            }
            
            .w3-top .w3-bar {
                z-index: 1000;
            }
            
            /* Ensure mobile menu items are properly spaced */
            #navDemo .w3-bar-item {
                padding: 12px 16px !important;
                border-bottom: 1px solid #f1f1f1;
            }
        }
        
        /* Print styles */
        @media print {
            .w3-bar, footer, .w3-button {
                display: none !important;
            }
            
            .bgimg-1, .bgimg-2, .bgimg-3 {
                background: none !important;
                color: #000 !important;
            }
        }
    </style>
</head>
<body>

<!-- Modern Header -->
<header class="w3-top">
    <nav class="w3-bar modern-header" id="myNavbar">
        <!-- Logo -->
        <a href="<?php echo e(route('home')); ?>" class="w3-bar-item w3-button logo-text w3-hover-none">
            <?php echo e($siteSettings['site_title'] ?? 'PORTFOLIO'); ?>

        </a>
        
        <!-- Mobile Menu Button -->
        <button class="w3-bar-item mobile-menu-btn w3-hide-medium w3-hide-large w3-right" onclick="toggleFunction()" title="Toggle Navigation Menu">
            <i class="fa fa-bars"></i>
        </button>
        
        <!-- Desktop Navigation -->
        <div class="w3-right w3-hide-small">
            <a href="<?php echo e(route('home')); ?>" class="w3-bar-item w3-button modern-nav-item">
                <i class="fa fa-home w3-margin-right"></i>HOME
            </a>
            <a href="<?php echo e(route('about')); ?>" class="w3-bar-item w3-button modern-nav-item">
                <i class="fa fa-user w3-margin-right"></i>ABOUT
            </a>
            <a href="<?php echo e(route('portfolio.index')); ?>" class="w3-bar-item w3-button modern-nav-item">
                <i class="fa fa-th w3-margin-right"></i>PORTFOLIO
            </a>
            <a href="<?php echo e(route('contact')); ?>" class="w3-bar-item w3-button modern-nav-item">
                <i class="fa fa-envelope w3-margin-right"></i>CONTACT
            </a>
        </div>
    </nav>

    <!-- Mobile Navigation Menu -->
    <div id="navDemo" class="mobile-menu w3-bar-block w3-hide w3-hide-large w3-hide-medium">
        <a href="<?php echo e(route('home')); ?>" class="w3-bar-item w3-button" onclick="toggleFunction()">
            <i class="fa fa-home w3-margin-right"></i>HOME
        </a>
        <a href="<?php echo e(route('about')); ?>" class="w3-bar-item w3-button" onclick="toggleFunction()">
            <i class="fa fa-user w3-margin-right"></i>ABOUT
        </a>
        <a href="<?php echo e(route('portfolio.index')); ?>" class="w3-bar-item w3-button" onclick="toggleFunction()">
            <i class="fa fa-th w3-margin-right"></i>PORTFOLIO
        </a>
        <a href="<?php echo e(route('contact')); ?>" class="w3-bar-item w3-button" onclick="toggleFunction()">
            <i class="fa fa-envelope w3-margin-right"></i>CONTACT
        </a>
    </div>
</header>

<?php echo $__env->yieldContent('content'); ?>

<!-- Modern Footer -->
<footer class="modern-footer w3-padding-64">
    <div class="footer-content w3-center">
        <!-- Back to Top Button -->
        <button onclick="scrollToTop()" class="back-to-top">
            <i class="fa fa-arrow-up w3-margin-right"></i>BACK TO TOP
        </button>
        
        <!-- Footer Divider -->
        <div class="footer-divider"></div>
        
        <!-- Social Media Links -->
        <?php if(isset($contactInfo) && $contactInfo->where('type', 'social')->count() > 0): ?>
            <div class="social-links">
                <?php $__currentLoopData = $contactInfo->where('type', 'social'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($contact->is_active && filter_var($contact->value, FILTER_VALIDATE_URL)): ?>
                        <a href="<?php echo e($contact->value); ?>" target="_blank" class="social-link" title="<?php echo e($contact->label); ?>">
                            <i class="fa <?php echo e($contact->icon ?? 'fa-share-alt'); ?>"></i>
                        </a>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            <div class="social-links">
                <a href="#" class="social-link" title="Facebook">
                    <i class="fa fa-facebook"></i>
                </a>
                <a href="#" class="social-link" title="Twitter">
                    <i class="fa fa-twitter"></i>
                </a>
                <a href="#" class="social-link" title="LinkedIn">
                    <i class="fa fa-linkedin"></i>
                </a>
                <a href="#" class="social-link" title="Instagram">
                    <i class="fa fa-instagram"></i>
                </a>
                <a href="#" class="social-link" title="GitHub">
                    <i class="fa fa-github"></i>
                </a>
            </div>
        <?php endif; ?>
        
        <!-- Footer Text -->
        <div class="footer-text">
            <p style="margin: 0;">
                <?php echo e($siteSettings['footer_text'] ?? 'Crafted with ❤️ using Laravel & Modern Web Technologies'); ?>

            </p>
            <p style="margin: 10px 0 0 0; font-size: 12px; opacity: 0.6;">
                © <?php echo e(date('Y')); ?> <?php echo e($siteSettings['site_title'] ?? 'Portfolio'); ?>. All rights reserved.
            </p>
        </div>
    </div>
</footer>

<script>
// Modern navbar scroll effect
window.onscroll = function() {modernNavbarScroll()};
function modernNavbarScroll() {
    var navbar = document.getElementById("myNavbar");
    if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
        navbar.classList.add("scrolled");
    } else {
        navbar.classList.remove("scrolled");
    }
}

// Enhanced mobile menu toggle
function toggleFunction() {
    var menu = document.getElementById("navDemo");
    if (menu.className.indexOf("w3-show") == -1) {
        menu.className += " w3-show";
        // Add smooth animation
        menu.style.animation = "slideDown 0.3s ease";
    } else {
        menu.style.animation = "slideUp 0.3s ease";
        setTimeout(function() {
            menu.className = menu.className.replace(" w3-show", "");
        }, 250);
    }
}

// Smooth scroll to top
function scrollToTop() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
}

// Add smooth scrolling for anchor links
document.addEventListener('DOMContentLoaded', function() {
    // Add active state to current page navigation
    var currentPage = window.location.pathname;
    var navLinks = document.querySelectorAll('.modern-nav-item');
    
    navLinks.forEach(function(link) {
        var href = link.getAttribute('href');
        if (href === currentPage || (currentPage === '/' && href.includes('home'))) {
            link.style.color = '#007bff';
            link.style.fontWeight = '600';
        }
    });
    
    // Add scroll animations
    var observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    var observer = new IntersectionObserver(function(entries) {
        entries.forEach(function(entry) {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);
    
    // Observe elements for animation
    var animateElements = document.querySelectorAll('.w3-card, .w3-container');
    animateElements.forEach(function(el) {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'all 0.6s ease';
        observer.observe(el);
    });
    
    // Statistics Counter Animation
    function animateCounters() {
        var counters = document.querySelectorAll('.stat-counter');
        var progressBars = document.querySelectorAll('.stat-progress-fill');
        
        var statsObserver = new IntersectionObserver(function(entries) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    var counter = entry.target;
                    var targetValue = parseInt(counter.getAttribute('data-count'));
                    var currentValue = 0;
                    var increment = targetValue / 50; // 50 steps for smooth animation
                    var duration = 2000; // 2 seconds
                    var stepTime = duration / 50;
                    
                    counter.classList.add('animate');
                    
                    var timer = setInterval(function() {
                        currentValue += increment;
                        if (currentValue >= targetValue) {
                            currentValue = targetValue;
                            clearInterval(timer);
                        }
                        counter.textContent = Math.floor(currentValue);
                    }, stepTime);
                    
                    // Animate progress bar
                    var card = counter.closest('.modern-stat-card');
                    var progressBar = card.querySelector('.stat-progress-fill');
                    if (progressBar) {
                        setTimeout(function() {
                            var percentage = progressBar.getAttribute('data-percentage');
                            progressBar.style.width = percentage + '%';
                        }, 500);
                    }
                    
                    statsObserver.unobserve(counter);
                }
            });
        }, {
            threshold: 0.5
        });
        
        counters.forEach(function(counter) {
            statsObserver.observe(counter);
        });
    }
    
    // Initialize counter animations
    animateCounters();
    
    // Add stagger effect to stat cards
    var statCards = document.querySelectorAll('.modern-stat-card');
    statCards.forEach(function(card, index) {
        card.style.animationDelay = (index * 0.1) + 's';
    });
    
    // Skills Progress Bar Animation
    function animateSkillBars() {
        var skillBars = document.querySelectorAll('.skill-progress-bar');
        
        var skillsObserver = new IntersectionObserver(function(entries) {
            entries.forEach(function(entry) {
                if (entry.isIntersecting) {
                    var progressBar = entry.target;
                    var percentage = progressBar.getAttribute('data-percentage');
                    
                    setTimeout(function() {
                        progressBar.style.width = percentage + '%';
                    }, 200);
                    
                    skillsObserver.unobserve(progressBar);
                }
            });
        }, {
            threshold: 0.5
        });
        
        skillBars.forEach(function(bar) {
            skillsObserver.observe(bar);
        });
    }
    
    // Initialize skill bar animations
    animateSkillBars();
});
</script>

</body>
</html>
<?php /**PATH /opt/lampp/htdocs/pinky/resources/views/layouts/frontend.blade.php ENDPATH**/ ?>