<?php $__env->startSection('title', 'View Contact Message'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Message</h1>
    <a href="<?php echo e(route('admin.contact-messages.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Messages
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    Message from <?php echo e($contactMessage->name); ?>

                    <?php if(!$contactMessage->is_read): ?>
                        <span class="badge bg-warning">Unread</span>
                    <?php else: ?>
                        <span class="badge bg-success">Read</span>
                    <?php endif; ?>
                </h5>
                <div class="btn-group btn-group-sm" role="group">
                    <form action="<?php echo e(route('admin.contact-messages.toggle-read', $contactMessage)); ?>" method="POST" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-outline-<?php echo e($contactMessage->is_read ? 'warning' : 'success'); ?>">
                            <i class="fas fa-<?php echo e($contactMessage->is_read ? 'envelope' : 'envelope-open'); ?>"></i>
                            Mark as <?php echo e($contactMessage->is_read ? 'Unread' : 'Read'); ?>

                        </button>
                    </form>
                    <form action="<?php echo e(route('admin.contact-messages.destroy', $contactMessage)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-outline-danger">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <h6 class="text-muted">Message Content:</h6>
                    <div class="border rounded p-3 bg-light">
                        <?php echo nl2br(e($contactMessage->message)); ?>

                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-muted">Contact Information:</h6>
                        <p><strong>Name:</strong> <?php echo e($contactMessage->name); ?></p>
                        <p><strong>Email:</strong> 
                            <a href="mailto:<?php echo e($contactMessage->email); ?>"><?php echo e($contactMessage->email); ?></a>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted">Message Details:</h6>
                        <p><strong>Received:</strong> <?php echo e($contactMessage->created_at->format('F j, Y \a\t g:i A')); ?></p>
                        <p><strong>IP Address:</strong> <?php echo e($contactMessage->ip_address ?? 'Not recorded'); ?></p>
                        <?php if($contactMessage->is_read && $contactMessage->read_at): ?>
                            <p><strong>Read At:</strong> <?php echo e($contactMessage->read_at->format('F j, Y \a\t g:i A')); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="mailto:<?php echo e($contactMessage->email); ?>?subject=Re: Your message&body=Hello <?php echo e($contactMessage->name); ?>,%0D%0A%0D%0AThank you for your message:%0D%0A%0D%0A<?php echo e(urlencode($contactMessage->message)); ?>%0D%0A%0D%0ABest regards," 
                       class="btn btn-primary">
                        <i class="fas fa-reply"></i> Reply via Email
                    </a>
                    
                    <button class="btn btn-info" onclick="copyToClipboard('<?php echo e($contactMessage->email); ?>')">
                        <i class="fas fa-copy"></i> Copy Email Address
                    </button>
                    
                    <a href="<?php echo e(route('admin.contact-messages.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-list"></i> View All Messages
                    </a>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Message Statistics</h5>
            </div>
            <div class="card-body">
                <small class="text-muted">
                    <p><strong>Message Length:</strong> <?php echo e(strlen($contactMessage->message)); ?> characters</p>
                    <p><strong>Word Count:</strong> <?php echo e(str_word_count($contactMessage->message)); ?> words</p>
                    <p><strong>Time Since Received:</strong> <?php echo e($contactMessage->created_at->diffForHumans()); ?></p>
                </small>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Email address copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/contact-messages/show.blade.php ENDPATH**/ ?>