<?php $__env->startSection('title', 'Skills'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Skills</h1>
    <a href="<?php echo e(route('admin.skills.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Skill
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($skills->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Preview</th>
                            <th>Skill Name</th>
                            <th>Percentage</th>
                            <th>Color</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div style="width: 100px; height: 20px; background: #f0f0f0; border-radius: 10px; overflow: hidden;">
                                        <div style="width: <?php echo e($skill->percentage); ?>%; height: 100%; background: <?php echo e($skill->color); ?>; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                                            <small class="text-white" style="font-size: 10px;"><?php echo e($skill->percentage); ?>%</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <strong><?php echo e($skill->name); ?></strong>
                                </td>
                                <td>
                                    <span class="badge bg-info"><?php echo e($skill->percentage); ?>%</span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div style="width: 20px; height: 20px; background: <?php echo e($skill->color); ?>; border-radius: 3px; margin-right: 8px;"></div>
                                        <code><?php echo e($skill->color); ?></code>
                                    </div>
                                </td>
                                <td>
                                    <?php if($skill->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($skill->sort_order ?? 0); ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.skills.show', $skill)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.skills.edit', $skill)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.skills.destroy', $skill)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this skill?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-star fa-3x mb-3"></i>
                <p class="h5">No skills found</p>
                <p>Start by adding your first skill to showcase your expertise.</p>
                <a href="<?php echo e(route('admin.skills.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Skill
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($skills->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Skills Overview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo e($skills->count()); ?></h4>
                            <small class="text-muted">Total Skills</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo e($skills->where('is_active', true)->count()); ?></h4>
                            <small class="text-muted">Active Skills</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo e($skills->avg('percentage') ? round($skills->avg('percentage')) : 0); ?>%</h4>
                            <small class="text-muted">Average Level</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo e($skills->where('percentage', '>=', 90)->count()); ?></h4>
                            <small class="text-muted">Expert Level (90%+)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/skills/index.blade.php ENDPATH**/ ?>