<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\SiteSetting;

class SiteSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $settings = [
            ['key' => 'site_title', 'value' => 'My Portfolio Website', 'type' => 'text', 'group' => 'general'],
            ['key' => 'site_logo', 'value' => 'MY WEBSITE LOGO', 'type' => 'text', 'group' => 'general'],
            ['key' => 'hero_background', 'value' => 'https://www.w3schools.com/w3images/parallax1.jpg', 'type' => 'image', 'group' => 'hero'],
            ['key' => 'portfolio_background', 'value' => 'https://www.w3schools.com/w3images/parallax2.jpg', 'type' => 'image', 'group' => 'portfolio'],
            ['key' => 'contact_background', 'value' => 'https://www.w3schools.com/w3images/parallax3.jpg', 'type' => 'image', 'group' => 'contact'],
            ['key' => 'about_title', 'value' => 'ABOUT ME', 'type' => 'text', 'group' => 'about'],
            ['key' => 'about_subtitle', 'value' => 'I love photography', 'type' => 'text', 'group' => 'about'],
            ['key' => 'profile_image', 'value' => 'https://www.w3schools.com/w3images/avatar_hat.jpg', 'type' => 'image', 'group' => 'about'],
            ['key' => 'welcome_text', 'value' => 'Welcome to my website. I am lorem ipsum consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'type' => 'textarea', 'group' => 'about'],
            ['key' => 'portfolio_title', 'value' => 'MY WORK', 'type' => 'text', 'group' => 'portfolio'],
            ['key' => 'portfolio_subtitle', 'value' => 'Here are some of my latest lorem work ipsum tipsum.', 'type' => 'text', 'group' => 'portfolio'],
            ['key' => 'portfolio_description', 'value' => 'Click on the images to make them bigger', 'type' => 'text', 'group' => 'portfolio'],
            ['key' => 'contact_title', 'value' => 'WHERE I WORK', 'type' => 'text', 'group' => 'contact'],
            ['key' => 'contact_subtitle', 'value' => 'I\'d love your feedback!', 'type' => 'text', 'group' => 'contact'],
            ['key' => 'contact_message', 'value' => 'Swing by for a cup of ☕, or leave me a note:', 'type' => 'text', 'group' => 'contact'],
            ['key' => 'footer_text', 'value' => 'Powered by Laravel & W3.CSS', 'type' => 'text', 'group' => 'general'],
        ];

        foreach ($settings as $index => $setting) {
            SiteSetting::create(array_merge($setting, ['sort_order' => $index + 1]));
        }
    }
}
