<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SiteSetting;
use App\Models\AboutSection;
use App\Models\Skill;
use App\Models\Statistic;
use App\Models\ContactInfo;
use App\Models\Banner;

class AboutController extends Controller
{
    public function index()
    {
        $data = [
            'siteSettings' => $this->getSiteSettings(),
            'aboutSections' => AboutSection::active()->ordered()->get(),
            'skills' => Skill::active()->ordered()->get(),
            'statistics' => Statistic::active()->ordered()->get(),
            'contactInfo' => ContactInfo::active()->ordered()->get(),
            'banners' => [
                'about' => Banner::getForPosition('about'),
            ],
        ];

        return view('frontend.about', $data);
    }

    private function getSiteSettings()
    {
        $settings = SiteSetting::all();
        $data = [];
        
        foreach ($settings as $setting) {
            $data[$setting->key] = $setting->value;
        }
        
        return $data;
    }
}
